% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_correction.R
\name{eem_remove_scattering}
\alias{eem_remove_scattering}
\title{Remove Raman and Rayleigh scattering}
\usage{
eem_remove_scattering(eem, type, order = 1, width = 10)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{type}{A string, either "raman" or "rayleigh".}

\item{order}{A integer number, either 1 (first order) or 2 (second order).}

\item{width}{Slit width in nm for the cut. Default is 10 nm.}
}
\value{
An object of class \code{eemlist}.
}
\description{
Remove Raman and Rayleigh scattering
}
\examples{
# Open the fluorescence eem
file <- system.file("extdata/cary/scans_day_1", "sample1.csv", package = "eemR")
eem <- eem_read(file)

plot(eem)

# Remove the scattering
eem <- eem_remove_scattering(eem = eem, type = "raman", order = 1, width = 10)

plot(eem)
}
\references{
Lakowicz, J. R. (2006). Principles of Fluorescence Spectroscopy.
Boston, MA: Springer US.#'

\url{http://doi.org/10.1007/978-0-387-46312-4}

Murphy, K. R., Stedmon, C. a., Graeber, D., & Bro, R. (2013).
Fluorescence spectroscopy and multi-way techniques. PARAFAC. Analytical
Methods, 5(23), 6557. http://doi.org/10.1039/c3ay41160e#'

 \url{http://xlink.rsc.org/?DOI=c3ay41160e}
}

