% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taylor-manifest-anxiety-scale-data.R
\docType{data}
\name{items_taylor_manifest_anxiety_scale}
\alias{items_taylor_manifest_anxiety_scale}
\title{Taylor Manifest Anxiety Scale Item Responses}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 4468 rows and 50 columns.
}
\usage{
items_taylor_manifest_anxiety_scale
}
\description{
Taylor Manifest Anxiety Scale Item Responses
}
\details{
Questions alongside of their correct answer is based off of Table 1 of the
Taylor (1953) paper.

Items with their desired response bolded:
\itemize{
\item \code{Q1}: I do not tire quickly. \strong{(False)}
\item \code{Q2}: I am troubled by attacks of nausea. \strong{(True)}
\item \code{Q3}: I believe I am no more nervous than most others. \strong{(False)}
\item \code{Q4}: I have very few headaches. \strong{(False)}
\item \code{Q5}: I work under a great deal of tension. \strong{(True)}
\item \code{Q6}: I cannot keep my mind on one thing. \strong{(True)}
\item \code{Q7}: I worry over money and business. \strong{(True)}
\item \code{Q8}: I frequently notice my hand shakes when I try to do something. \strong{(True)}
\item \code{Q9}: I blush no more often than others. \strong{(False)}
\item \code{Q10}: I have diarrhea once a month or more. \strong{(True)}
\item \code{Q11}: I worry quite a bit over possible misfortunes. \strong{(True)}
\item \code{Q12}: I practically never blush. \strong{(False)}
\item \code{Q13}: I am often afraid that I am going to blush. \strong{(True)}
\item \code{Q14}: I have nightmares every few nights. \strong{(True)}
\item \code{Q15}: My hands and feet are usually warm. \strong{(False)}
\item \code{Q16}: I sweat very easily even on cool days. \strong{(True)}
\item \code{Q17}: Sometimes when embarrassed, I break out in a sweat. \strong{(True)}
\item \code{Q18}: I hardly ever notice my heart pounding and I am seldom short of breath. \strong{(False)}
\item \code{Q19}: I feel hungry almost all the time. \strong{(True)}
\item \code{Q20}: I am very seldom troubled by constipation. \strong{(False)}
\item \code{Q21}: I have a great deal of stomach trouble. \strong{(True)}
\item \code{Q22}: I have had periods in which I lost sleep over worry. \strong{(True)}
\item \code{Q23}: My sleep is fitful and disturbed. \strong{(True)}
\item \code{Q24}: I dream frequently about things that are best kept to myself. \strong{(True)}
\item \code{Q25}: I am easily embarrassed. \strong{(True)}
\item \code{Q26}: I am more sensitive than most other people. \strong{(True)}
\item \code{Q27}: I frequently find myself worrying about something. \strong{(True)}
\item \code{Q28}: I wish I could be as happy as others seem to be. \strong{(True)}
\item \code{Q29}: I am usually calm and not easily upset. \strong{(False)}
\item \code{Q30}: I cry easily. \strong{(True)}
\item \code{Q31}: I feel anxiety about something or someone almost all the time. \strong{(True)}
\item \code{Q32}: I am happy most of the time. \strong{(False)}
\item \code{Q33}: It makes me nervous to have to wait. \strong{(True)}
\item \code{Q34}: I have periods of such great restlessness that I cannot sit long I a chair. \strong{(True)}
\item \code{Q35}: Sometimes I become so excited that I find it hard to get to sleep. \strong{(True)}
\item \code{Q36}: I have sometimes felt that difficulties were piling up so high that I could not overcome them. \strong{(True)}
\item \code{Q37}: I must admit that I have at times been worried beyond reason over something that really did not matter. \strong{(True)}
\item \code{Q38}: I have very few fears compared to my friends. \strong{(False)}
\item \code{Q39}: I have been afraid of things or people that I know could not hurt me. \strong{(True)}
\item \code{Q40}: I certainly feel useless at times. \strong{(True)}
\item \code{Q41}: I find it hard to keep my mind on a task or job. \strong{(True)}
\item \code{Q42}: I am usually self-conscious. \strong{(True)}
\item \code{Q43}: I am inclined to take things hard. \strong{(True)}
\item \code{Q44}: I am a high-strung person. \strong{(True)}
\item \code{Q45}: Life is a trial for me much of the time. \strong{(True)}
\item \code{Q46}: At times I think I am no good at all. \strong{(True)}
\item \code{Q47}: I am certainly lacking in self-confidence. \strong{(True)}
\item \code{Q48}: I sometimes feel that I am about to go to pieces. \strong{(True)}
\item \code{Q49}: I shrink from facing crisis of difficulty. \strong{(True)}
\item \code{Q50}: I am entirely self-confident. \strong{(False)}
}
}
\section{Data pre-processing}{

We have applied list-wise deletion during pre-processing to remove any
observations with missing values from the data set.
}

\section{Answer coding}{

The subjects answered a set of assessment items seeking to determine
the level of anxiety. Answers given in \strong{bold} represent the desired
response. If a subject matched this response, they were given a 1 inside
of the item matrix, otherwise they received a zero.
}

\references{
\strong{Assessment Design:}
\itemize{
\item Taylor, J. A. (1953). \emph{A personality scale of manifest anxiety}.
The Journal of Abnormal and Social Psychology, 48(2), 285–290.
\doi{10.1037/h0056264}.
}

\strong{Data originated from:}
\itemize{
\item OpenPsychometrics. 2012. \emph{Taylor Manifest Anxiety Scale}.
\url{https://openpsychometrics.org/_rawdata/TMA.zip}.
}

\strong{Data used in:}
\itemize{
\item TBA
}
}
\keyword{datasets}
