% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBusinessDescr.R
\name{getBusinDescr}
\alias{getBusinDescr}
\title{Retrieves business descriptions from annual statements}
\usage{
getBusinDescr(cik.no, filing.year)
}
\arguments{
\item{cik.no}{vector of firm CIK(s) in integer format. Suppress leading 
zeroes from a CIK number. cik.no = 'ALL' considers all the CIKs.}

\item{filing.year}{vector of four digit numeric year}
}
\value{
Function saves scrapped business description section from annual 
filings in "edgar_BusinDescr" directory created in the current 
working directory. The output dataframe contains filing information and 
parsing status. For a successful extraction of this section, 
'extract.status' column returns 1, other return 0 for failed extraction.
}
\description{
\code{getBusinessDescr} retrieves business description section from annual statements 
based on CIK number(s) and filing year(s).
}
\details{
getBusinDescr function takes firm CIK(s) and filing year(s) as input parameters from 
a user and provides "Item 1" section extracted from annual statements along with 
filing information. The function imports annual filings (10-K statements) downloaded 
via \link[edgar]{getFilings} function; otherwise, it automates the downloading process 
if not already been downloaded. It then reads the downloaded statements, cleans HTML tags, 
and parse the contents. This function automatically creates a new directory with 
the name "edgar_BusinDescr" in the current working directory and 
saves scrapped business description sections in this directory. It considers "10-K", 
"10-K405", "10KSB", and "10KSB40" form types as annual statements. 
User must follow the US SEC's fair access policy, i.e. download only what you 
need and limit your request rates, see \url{https://www.sec.gov/os/accessing-edgar-data}.
}
\examples{
\dontrun{

output <- getBusinDescr(cik.no = c(1000180, 38079), filing.year = 2005)
## saves scrapped "Item 1" section from 10-K filings for CIKs in 
"edgar_BusinDescr" directory present 
in the working directory. Also, it provides filing information in 
the output datframe.

output <- getBusinDescr(cik.no = c(1000180, 38079), 
                        filing.year = c(2005, 2006))
}
}
