% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd.R
\name{partial_dependence}
\alias{partial_dependence}
\title{Partial dependence using random forests}
\usage{
partial_dependence(fit, data, var, cutoff = 10L, interaction = FALSE,
  oob = TRUE, parallel = FALSE, clean_names = TRUE)
}
\arguments{
\item{fit}{object of class 'RandomForest', 'randomForest', or 'rfsrc'}

\item{data}{the data.frame used to fit the model, only needed for randomForest}

\item{var}{a character vector of the predictors of interest, which must match the input matrix}

\item{cutoff}{the maximal number of unique points in each element of 'var' used in the
partial dependence calculation}

\item{interaction}{logical, if 'var' is a vector, does this specify an interaction or a list of bivariate partial dependence}

\item{oob}{logical, use the out-of-bag data to compute predictions at each step}

\item{parallel}{logical indicator of whether a parallel backend should be used if registered}

\item{clean_names}{logical indicator of whether to clean factor names in output i.e. "level" instead of "factorname.level."}
}
\value{
a data.frame with the partial dependence of 'var'
if 'var' has length = 1 then the output will be a data.frame with a column for the predicted value at each value of 'var', averaged over the values of all other predictors.
if 'var' has length > 1 and interaction is true or false then the output will be a data.frame with a column for each element of 'var' and the predicted value for each combination.
}
\description{
Calculates the partial dependence of the response on an arbitrary dimensional set of predictors
from a fitted random forest object from the party, randomForest, or randomForestSRC packages
}
\examples{
library(randomForest)
library(edarf)

data(iris)
data(swiss)

## classification
fit <- randomForest(Species ~ ., iris)
pd <- partial_dependence(fit, iris, c("Petal.Width", "Sepal.Length"))
pd_int <- partial_dependence(fit, iris, c("Petal.Width", "Sepal.Length"), interaction = TRUE)

## Regression
fit <- randomForest(Fertility ~ ., swiss)
pd <- partial_dependence(fit, swiss, "Education")
pd_int <- partial_dependence(fit, swiss, c("Education", "Catholic"), interaction = TRUE)
}
\references{
Friedman, Jerome H. "Greedy function approximation: a gradient boosting machine." Annals of statistics (2001): 1189-1232.
}
\seealso{
\code{\link{plot_pd}} for plotting \code{partial_dependence}.
}

