% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exam3.1.1.R
\name{Exam3.1.1}
\alias{Exam3.1.1}
\title{Example 3.1.1 from Experimental Design and Analysis for Tree Improvement}
\description{
Exam3.1.1 is part of data from Australian Centre for Agricultural Research (ACIAR)
             in Queensland, Australia (Experiment 309).
}
\examples{
library(car)
library(dae)
library(dplyr)
library(emmeans)
library(ggplot2)
library(lmerTest)
library(magrittr)
library(predictmeans)
library(supernova)

data(DataExam3.1.1)

# Pg. 36
fm3.8 <- lm(formula  = Mean ~ Repl + SeedLot, data = DataExam3.1.1)

# Pg. 40
anova(fm3.8)

# Pg. 40
emmeans(object = fm3.8, specs = ~ SeedLot)
emmip(object = fm3.8, formula  = ~ SeedLot) +
 theme_classic()

}
\references{
\enumerate{
         \item E.R. Williams, C.E. Harwood and A.C. Matheson (2023). \emph{Experimental Design and Analysis for Tree Improvement}.
               CSIRO Publishing (\href{https://www.publish.csiro.au/book/3145/}{https://www.publish.csiro.au/book/3145/}).
             }
}
\seealso{
\code{\link{DataExam3.1.1}}
}
\author{
\enumerate{
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item  Sami Ullah (\email{samiullahuos@gmail.com})
         }
}
