% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_db.R
\name{calculate_db}
\alias{calculate_db}
\title{Calculate accuracy of temperature regulation}
\usage{
calculate_db(tb, tset_low, tset_up)
}
\arguments{
\item{tb}{A vector containing body temperature measurements.}

\item{tset_low}{Lower boundary of a species or population set-point range 
that was determined through thermal preference trials in a temperature 
gradient.}

\item{tset_up}{Upper boundary of the set-point range.}
}
\value{
Degree to which ectotherms experience body temperatures outside 
their set-point range (db), and associated descriptive statistics.
}
\description{
This function determines the degree to which ectotherms experience body 
temperatures outside their set-point range, better known as the accuracy of 
temperature regulation (db) as described by Hertz et al. (1993). Descriptive 
statistics are automatically computed as well.
}
\examples{
tb <- na.omit(bufbuf[,"tb"])
db_stats <- calculate_db(tb, 19.35, 26.44)

}
\references{
Hertz, P. E., Huey, R. B., & Stevenson, R. D. (1993). Evaluating temperature 
regulation by field-active ectotherms: the fallacy of the inappropriate 
question. The American Naturalist, 142(5), 796-818.
}
