% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPredictions.R
\name{getPredictions}
\alias{getPredictions}
\title{Get predictions}
\usage{
getPredictions(
  rasts,
  mods,
  region = NULL,
  type = "cloglog",
  clamp = TRUE,
  file = NULL,
  verbosity = 2
)
}
\arguments{
\item{rasts}{(multi-layer) SpatRaster containing the variables (with the same names) used in the models.}

\item{mods}{output of \code{\link[=getModels]{getModels()}}.}

\item{region}{optional SpatExtent or SpatVector polygon delimiting the region of 'rasts' within which to compute the predictions. The default is NULL, to use the entire extent of 'rasts'. Note that predictions may be unreliable outside the 'region' used for \code{\link[=getModels]{getModels()}}, as they are extrapolating beyond the analysed conditions.}

\item{type}{character value to pass to \code{\link[=predict]{predict()}} indicating the type of response to compute. Can be "cloglog" (the default and currently recommended), "logistic" (previously but no longer recommended) (Phillips et al., 2017), "exponential", or "link".}

\item{clamp}{logical value to pass to \code{\link[=predict]{predict()}} indicating whether predictors and features should be restricted to the range seen during model training. Default TRUE.}

\item{file}{optional folder name (including path within the working directory) if you want the prediction rasters to be saved to disk. If 'file' already exists in the working directory (meaning that predictions were already computed), predictions are imported from there.}

\item{verbosity}{integer value indicating the amount of messages to display. The default is 2, for the maximum number of messages available.}
}
\value{
This function returns a SpatRasterDataset with one sub-dataset per period, each of which is a (multilayer) SpatRaster with the predictions of each replicate (if there are replicates) for that period.
}
\description{
Get predictions
}
\examples{
# Several data prep steps required.
# See https://github.com/AMBarbosa/ecotrends for a full worked example.
}
\references{
Phillips, S.J., Anderson, R.P., Dudik, M., Schapire, R.E., Blair, M.E., 2017. Opening the black box: an open-source release of Maxent. Ecography 40, 887-893. https://doi.org/10.1111/ecog.03049
}
\author{
A. Marcia Barbosa
}
