% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostate.R
\name{ecostate_control}
\alias{ecostate_control}
\title{Detailed control for ecostate structure}
\usage{
ecostate_control(
  nlminb_loops = 1,
  newton_loops = 0,
  eval.max = 1000,
  iter.max = 1000,
  getsd = TRUE,
  silent = getOption("ecostate.silent", TRUE),
  trace = getOption("ecostate.trace", 0),
  verbose = getOption("ecostate.verbose", FALSE),
  profile = c("logF_ti", "log_winf_z", "s50_z", "srate_z"),
  random = c("epsilon_ti", "alpha_ti", "nu_ti", "phi_tg2"),
  tmb_par = NULL,
  map = NULL,
  getJointPrecision = FALSE,
  integration_method = c("ABM", "RK4", "ode23", "rk4", "lsoda"),
  process_error = c("epsilon", "alpha"),
  n_steps = 10,
  F_type = c("integrated", "averaged"),
  derived_quantities = c("h_g2", "B_ti", "B0_i"),
  scale_solver = c("joint", "simple"),
  inverse_method = c("Standard", "Penrose_moore"),
  tmbad.sparse_hessian_compress = 1,
  start_tau = 0.001
)
}
\arguments{
\item{nlminb_loops}{Integer number of times to call \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{newton_loops}{Integer number of Newton steps to do after running
\code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{eval.max}{Maximum number of evaluations of the objective function
allowed. Passed to \code{control} in \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{iter.max}{Maximum number of iterations allowed. Passed to \code{control} in
\code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{getsd}{Boolean indicating whether to call \code{\link[TMB:sdreport]{TMB::sdreport()}}}

\item{silent}{Disable terminal output for inner optimizer?}

\item{trace}{Parameter values are printed every \code{trace} iteration
for the outer optimizer. Passed to
\code{control} in \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{verbose}{Output additional messages about model steps during fitting?}

\item{profile}{parameters that are profiled across,
passed to \code{\link[RTMB]{MakeADFun}}}

\item{random}{parameters that are treated as random effects,
passed to \code{\link[RTMB]{MakeADFun}}}

\item{tmb_par}{list of parameters for starting values, with shape identical
to \code{tinyVAST(...)$internal$parlist}}

\item{map}{list of mapping values, passed to \link[RTMB:TMB-interface]{RTMB::MakeADFun}}

\item{getJointPrecision}{whether to get the joint precision matrix.  Passed
to \code{\link[TMB]{sdreport}}.}

\item{integration_method}{What numerical integration method to use. \code{"ABM"}
uses a native-R versions of Adam-Bashford, \code{"RK4"} uses a native-R
version of Runge-Kutta-4, and \code{"ode23"} uses a native-R
version of adaptive Runge-Kutta-23,
where all are adapted from \code{pracma} functions.
\code{"rk4"} and \code{lsoda} use those methods
from \code{deSolve::ode} as implemented by \code{RTMBode::ode}}

\item{process_error}{Whether to include process error as a continuous rate
(i.e., an "innovation" parameterization, \code{process_error="epsilon"})
or as a discrete difference between expected
and predicted biomass (i.e., a "state-space" parameterization),
\code{process_error="alpha"}The
former is more interpretable, whereas the latter is much more computationally
efficient.}

\item{n_steps}{number of steps used in the ODE solver for biomass dynamics}

\item{F_type}{whether to integrate catches along with biomass (\code{"integrated"})
or calculate catches from the Baranov catch equation applied to average
biomass (\code{"averaged"})}

\item{derived_quantities}{character-vector listing objects to ADREPORT}

\item{scale_solver}{Whether to solve for ecotrophic efficiency EE given biomass B
(\code{scale_solver="simple"}) or solve for a combination of EE and B values}

\item{inverse_method}{whether to use pseudoinverse or standard inverse}

\item{tmbad.sparse_hessian_compress}{passed to \code{\link[TMB:config]{TMB::config()}}, and enabling
an experimental feature to save memory when first computing the inner
Hessian matrix.  Using \code{tmbad.sparse_hessian_compress=1} seems
to have no effect on the MLE (although users should probably confirm this),
and hugely reduces memory use in both small
and large models. Using \code{tmbad.sparse_hessian_compress=1} seems
to hugely speed up the model-fitting with a large model but results in a small
decrease in speed for model-fitting with a small model.}

\item{start_tau}{Starting value for the standard deviation of process errors}
}
\value{
An S3 object of class "ecostate_control" that specifies detailed model settings,
allowing user specification while also specifying default values
}
\description{
Define a list of control parameters.
}
