% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity.R
\name{complexity}
\alias{complexity}
\title{Complexity indices}
\usage{
complexity(rca, method = "fitness", iterations = 20, extremality = 1,
  atlas = FALSE, tbl = TRUE, country = "country",
  product = "product", value = "value")
}
\arguments{
\item{rca}{matrix or data frame with RCA values}

\item{method}{which method to use (by default is "fitness", it can also
be "reflections" or "eigenvalues")}

\item{iterations}{number of iterations to use in the fitness, reflections
and indirectly in eigenvalues method (by default is 20)}

\item{extremality}{numeric coefficient to use in the fitness method
(by default is 1)}

\item{atlas}{remove the countries not ranked in The Atlas of Economic
Complexity (by default is FALSE)}

\item{tbl}{TRUE (default) returns a data.frame and FALSE returns a matrix}

\item{country}{column containing countries (applies only if d is a
data.frame)}

\item{product}{column containing products (applies only if d is a
data.frame)}

\item{value}{column containing traded values (applies only if d is a
data.frame)}
}
\value{
A list with four data frames or matrices.
}
\description{
\code{rca} computes complexity indices following the definitions
from \insertCite{measuringcomplexity2015;textual}{economiccomplexity}
}
\details{
Given a data frame or matrix with RCA
values as input, this function implements the fitness-complexity method,
and the reflections method and eigenvalues computation as alternatives.

The implementation of a recursive algorithm for both fitness-complexity and
reflections result in a fast computation.

Eigenvalues can be slow to compute as this method also calls reflections
method in order to check the correlation sign between the two metrics
to determine if there is a sign reversion in the numeric result.
}
\examples{
complexity(ec_output_demo$rca)

}
\references{
For more information about complexity measures see:

\insertRef{measuringcomplexity2015}{economiccomplexity}

and the references therein.
}
\seealso{
\code{\link[economiccomplexity]{rca}},
}
\keyword{functions}
