## ----setup, cache = FALSE, echo = FALSE, message = FALSE, warning = FALSE----
knitr::opts_chunk$set(eval = TRUE, message = FALSE, warning = FALSE)

## ------------------------------------------------------------------------
library(economiccomplexity)
ec_trade_1962

## ------------------------------------------------------------------------
r <- rca(ec_trade_1962)
r

## ------------------------------------------------------------------------
r2 <- rca(ec_trade_1962, discrete = F)
r2

## ------------------------------------------------------------------------
c <- complexity(r)
c

## ------------------------------------------------------------------------
p <- proximity(r, c$diversity, c$ubiquity)
p

## ------------------------------------------------------------------------
pr <- projections(p$proximity_c, p$proximity_p, 1, 1)
pr

## ---- fig.width=20, fig.height=12----------------------------------------
library(igraph)
library(ggraph)
library(magrittr)

set.seed(200100)

pr$projection_c %>%
  graph_from_data_frame(directed = F) %>%
  ggraph(layout = "kk") +
  geom_edge_link(aes(edge_alpha = value, edge_width = value),
                 edge_colour = "#a8a8a8") +
  geom_node_point(color = "darkslategray4", size = 8) +
  geom_node_text(aes(label = name), vjust = 2.2) +
  ggtitle("Country projection") +
  theme_void()

## ---- fig.width=20, fig.height=12----------------------------------------
pr$projection_p %>%
  graph_from_data_frame(directed = F) %>%
  ggraph(layout = "kk") +
  geom_edge_link(aes(edge_alpha = value, edge_width = value),
                 edge_colour = "#a8a8a8") +
  geom_node_point(color = "darkslategray4", size = 4) +
  geom_node_text(aes(label = name), vjust = 2.2) +
  ggtitle("Product projection") +
  theme_void()

