% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{jaccard}
\alias{jaccard}
\title{Jaccard}
\usage{
jaccard(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Jaccard beta diversity metric.
}
\section{Calculation}{


In the formulas below, \code{x} and \code{y} are two columns (samples) from \code{counts}.
\code{n} is the number of rows (OTUs) in \code{counts}.

\deqn{b = \displaystyle \frac{\sum_{i = 1}^{n} |x_i - y_i|}{\sum_{i = 1}^{n} x_i + y_i}}
\deqn{D = \displaystyle \frac{2b}{1 + b}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 2, 6)  
  y <- c(0, 8, 0, 0, 5)  
  bray <- sum(abs(x-y)) / sum(x+y)  
  2 * bray / (1 + bray)
  #>  0.7826087
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Jaccard weighted distance matrix
    jaccard(ex_counts)
    
    # Jaccard unweighted distance matrix
    jaccard(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    jaccard(ex_counts, pairs = 1:3)
    
}
\references{
Jaccard P 1908.
Nouvellesrecherches sur la distribution florale.
Bulletin de la Societe Vaudoise des Sciences Naturelles, 44(163).
\doi{10.5169/seals-268384}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
