% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{betaNested}
\alias{betaNested}
\title{Data set containing the results of applying ecocbo::sim_beta() to a nested
factors experiment.}
\format{
An object of class "ecocbo_beta", also a list containing four components.
The format is:
\describe{
\item{$Power}{
\describe{
\item{m}{number of sites considered for the result.}
\item{n}{number of replicates within each site for the result.}
\item{Power}{estimated statistical power.}
\item{Beta}{estimated type II error.}
\item{fCrit}{estimated pseudoF value that corresponds to the 1-alpha quartile of the distribution of pseudoF.}
}}
\item{$Results}{
\describe{
\item{dat.sim}{simulation from which the results are obtained.}
\item{k}{number of resample for the result.}
\item{m}{number of sites considered for the result.}
\item{n}{number of replicates within each site for the result.}
\item{pseudoFH0}{observed F value for the experimental design, when all observations belong to one site.}
\item{pseduoFHa}{observed F value for the experimental design, when observations belong to different sites.}
\item{MSB(A)}{calculated mean squares among sites in the experiment.}
\item{MSR}{calculated mean squares for the residuals in the experiment.}
}}
\item{$alpha}{usually 0.05}
\item{$model}{"nested.symmetric"}
\item{attribute}{"ecocbo.beta"}
}
}
\source{
Data available from the GitHub Digital Repository:
\url{https://github.com/edlinguerra/IA206320_publico/tree/main/datos} (Guerra-Castro
et al. 2022).
}
\usage{
betaNested
}
\description{
The dataset contains the results of applying ecocbo::sim_beta() to the dataset
from PAPIIT experiment. The result is a list with 4 components.
}
\details{
This dataset can be used to study the variability of the pseudoF-statistic,
beta and the power when an experiment is applied to a varying number of
samples, sampling units, or sampling sites.
}
\keyword{datasets}
