% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecmback.r
\name{ecmback}
\alias{ecmback}
\title{Backwards selection to build an error correction model}
\usage{
ecmback(y, xeq, xtr)
}
\arguments{
\item{y}{The target variable}

\item{xeq}{The variables to be used in the equilibrium term of the error correction model}

\item{xtr}{The variables to be used in the transient term of the error correction model}
}
\value{
an lm object representing an error correction model using backwards selection
}
\description{
Much like the ecm function, this builds an error correction model.
However, it uses backwards selection to select the optimal predictors based on lowest AIC, rather than using all predictors.
ecmback has the same parameters and output as ecm.
}
\examples{
#Use ecm to predict Fed Funds Rate based on Unemployment Rate, Inflation, and GDP Growth
data(FedData)

#Use 2015-12-01 and earlier data to build models
trn <- FedData[FedData$date<='2015-12-01',]

#Use backwards selection to choose which predictors are needed 
xeq <- xtr <- trn[c('UnemploymentRate', 'Inflation', 'GDPgrowth')]
modelback <- ecmback(trn$FedFundsRate, xeq, xtr)
print(modelback)
#Backwards selection chose Unemployment Rate and Inflation in the transient term. 
#Inflation and GDP Growth in the equilibrium term.

}
\seealso{
\code{lm}
}

