% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rda_functions.R
\name{r_prepare_data}
\alias{r_prepare_data}
\title{Prepare data for regression routines}
\usage{
r_prepare_data(data, response = "Y", exposure = "E", probe_names)
}
\arguments{
\item{data}{the data frame which contains the response, exposure, and genes
or cpgs or covariates. the columns should be labelled.}

\item{response}{the column name of the response in the \code{data} argument}

\item{exposure}{the column name of the exposure in the \code{data} argument}

\item{probe_names}{the column names of the genes, or cpg sites or covariates}
}
\value{
a list of length 5: \describe{\item{X}{the X matrix}\item{Y}{the
  response vector}\item{E}{the exposure vector}\item{main_effect_names}{the
  names of the main effects including the
  exposure}\item{interaction_names}{the names of the interaction effects}}
}
\description{
This function will output the appropriate X and Y matrices in
  the right format for regression packages such as \code{mgcv}, \code{caret}
  and \code{glmnet}
}
\examples{
data("tcgaov")
tcgaov[1:5,1:6, with = FALSE]
Y <- log(tcgaov[["OS"]])
E <- tcgaov[["E"]]
genes <- as.matrix(tcgaov[,-c("OS","rn","subtype","E","status"),with = FALSE])
trainIndex <- drop(caret::createDataPartition(Y, p = 0.5, list = FALSE, times = 1))
testIndex <- setdiff(seq_len(length(Y)),trainIndex)

\dontrun{
cluster_res <- r_cluster_data(data = genes,
                              response = Y,
                              exposure = E,
                              train_index = trainIndex,
                              test_index = testIndex,
                              cluster_distance = "tom",
                              eclust_distance = "difftom",
                              measure_distance = "euclidean",
                              clustMethod = "hclust",
                              cutMethod = "dynamic",
                              method = "average",
                              nPC = 1,
                              minimum_cluster_size = 50)

pc_eclust_interaction <- r_prepare_data(data = cbind(cluster_res$clustersAddon$PC,
                                                     survival = Y[trainIndex],
                                                     subtype = E[trainIndex]),
                                        response = "survival", exposure = "subtype")
names(pc_eclust_interaction)
dim(pc_eclust_interaction$X)
pc_eclust_interaction$main_effect_names
pc_eclust_interaction$interaction_names
}
}

