% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{map_actions}
\alias{map_actions}
\alias{e_map_select}
\alias{e_map_unselect}
\alias{e_map_toggle_select}
\title{Map Actions}
\usage{
e_map_select(e, ..., btn = NULL)

e_map_unselect(e, ..., btn = NULL)

e_map_toggle_select(e, ..., btn = NULL)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{...}{Any options, see \href{https://echarts.apache.org/en/api.html#action.map}{official documentation}}

\item{btn}{A \code{\link{e_button}} id.}
}
\description{
Map-related actions.
}
\examples{
choropleth <- data.frame(
  countries = c(
    "France",
    "Brazil",
    "China",
    "Russia",
    "Canada",
    "India",
    "United States",
    "Argentina",
    "Australia"
  ),
  values = round(runif(9, 10, 25))
)

choropleth |>
  e_charts(countries) |>
  e_map(values) |>
  e_visual_map(min = 10, max = 25) |>
  e_map_toggle_select(name = "China", btn = "btn") |>
  e_button("btn", "Select China")
}
\seealso{
\code{\link{e_map_register}}
}
