% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-solve-generic.R
\docType{methods}
\name{solve.ecd}
\alias{solve.ecd}
\alias{solve,ecd-method}
\title{Solve the elliptic curve \eqn{y(x)}}
\usage{
\method{solve}{ecd}(a, b, ...)

\S4method{solve}{ecd}(a, b, ...)
}
\arguments{
\item{a}{An object of ecd class}

\item{b}{A vector of \eqn{x} values}

\item{...}{Not used. Only here to match the generic signature.}
}
\value{
A vector of roots for \eqn{y(x)}
}
\description{
Solve the elliptic curve \eqn{y(x)} by constructing
a cubic polynomial from ecd object. Then solve it
and take the smallest real root.
}
\examples{
d <- ecd()
x <- seq(-100,100,by=0.1)
y <- solve(d,x)
}
\keyword{polynomial}
\keyword{solve}
