% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-mu-D-method.R
\name{ecld.mu_D}
\alias{ecld.mu_D}
\alias{ecld.mu_D_quartic}
\alias{ecld.mu_D_by_sum}
\alias{ecld.mu_D_integrate}
\title{mu_D of ecld}
\usage{
ecld.mu_D(object, validate = TRUE)

ecld.mu_D_quartic(object)

ecld.mu_D_by_sum(object)

ecld.mu_D_integrate(object, validate = TRUE)
}
\arguments{
\item{object}{an object of ecld class}

\item{validate}{logical, if true (default), stop when the result is NaN or infinite.}
}
\value{
numeric
}
\description{
The analytic solutions for risk-neutral drift. If analytic form doesn't
exist, it uses integral of unit distribution. This is different from
\code{ecld.mgf} where series summation is used.
}
\examples{
ld <- ecld(sigma=0.01*ecd.mp1)
ecld.mu_D(ld)
}
\author{
Stephen H. Lihn
}
\keyword{option-pricing}
