% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-imnt-method.R
\name{ecld.imnt}
\alias{ecld.imnt}
\alias{ecld.imnt_integrate}
\alias{ecld.imnt_sum}
\title{Incomplete moment (imnt) of ecld}
\usage{
ecld.imnt(object, ki, order, otype = "c")

ecld.imnt_integrate(object, ki, order, otype = "c")

ecld.imnt_sum(object, ki, order, otype = "c")
}
\arguments{
\item{object}{an object of ecld class}

\item{ki}{numeric vector of normalized log-strike, \code{(k-mu)/sigma}}

\item{order}{numeric. Order of the moment to be computed.
For \code{ecld.imnt_sum}, this is the maximum order to be truncated.
For small sigma at lambda=3, this can be simply 2.
If \code{Inf}, the slope truncation procedure will be used
to determine the maximum order. However, due to the numeric
limit of \code{pgamma}, it is capped at 100.}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}
}
\value{
numeric vector
}
\description{
The analytic solutions for imnt of ecld, if available.
Note that, by default, risk neutrality is honored.
\code{ecld.imnt_sum} provides an alternative method to calculate IMGF.
}
\examples{
ld <- ecld(sigma=0.01*ecd.mp1)
ki <- seq(-0.1, 0.1, by=0.01)
ecld.imnt(ld,ki, 1)
}
\author{
Stephen H-T. Lihn
}
\keyword{mgf}
