% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_test_preds}
\alias{load_test_preds}
\title{Test data predictions loader}
\usage{
load_test_preds(path, return_sf = FALSE)
}
\arguments{
\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
data.frame containing median, and upper and lower confidence
intervals are provided for predicted occurrence, count, and relativce
abundance.
}
\description{
Loads the model predictions for each checklist in the test dataset. Median,
and upper and lower confidence intervals are provided for predicted
occurrence, count, and relative abundance.
}
\examples{
\dontrun{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# test data
test_preds <- load_test_preds(sp_path)
dplyr::glimpse(test_preds)
}
}
