% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyVolcano.R
\name{easyManhattan}
\alias{easyManhattan}
\title{Interactive Manhattan plot labels}
\usage{
easyManhattan(
  data,
  chrom = "chrom",
  pos = "pos",
  p = "p",
  labs = "rsid",
  pcutoff = 5e-08,
  chromGap = NULL,
  chromCols = c("royalblue", "skyblue"),
  sigCol = "red",
  alpha = 0.7,
  labelDir = "horiz",
  xlab = "Chromosome position",
  ylab = expression("-log"[10] ~ "P"),
  outline_col = NA,
  shapeScheme = 16,
  size = 6,
  width = 1000,
  lineLength = 60,
  npoints = 1e+06,
  nplotly = 1e+05,
  npeaks = NULL,
  span = min(c(nrow(data), npoints), na.rm = TRUE)/200,
  transpose = FALSE,
  filename = NULL,
  ...
)
}
\arguments{
\item{data}{The dataset (data.frame or data.table) for the plot.}

\item{chrom}{The column of chomosome values in \code{data}.}

\item{pos}{The column of SNP positions in \code{data}.}

\item{p}{The column of p values in \code{data}.}

\item{labs}{The column of labels in \code{data}.}

\item{pcutoff}{Cut-off for p value significance. Defaults to 5E-08.}

\item{chromGap}{Size of gap between chromosomes along the x axis in base
pairs. If \code{NULL} this is automatically calculated dependent on the size of
the genome. Default is around 3E07 for a human genome, and smaller for
smaller genomes.}

\item{chromCols}{A vector of colours for points by chromosome. Colours are
recycled dependent on the length of the vector.}

\item{sigCol}{Colour for statistically significant points. Ignored if set to
\code{NA}.}

\item{alpha}{Transparency for points.}

\item{labelDir}{Option for label lines. See \code{\link[=easylabel]{easylabel()}}.}

\item{xlab}{x axis title. Accepts expressions.}

\item{ylab}{y axis title. Accepts expressions.}

\item{outline_col}{Colour of symbol outlines. Passed to \code{\link[=easylabel]{easylabel()}}.}

\item{shapeScheme}{A single symbol for points or a vector of symbols. Passed
to \code{\link[=easylabel]{easylabel()}}.}

\item{size}{Specifies point size. Passed to \code{\link[=easylabel]{easylabel()}}.}

\item{width}{Width of the plot in pixels. Saving to pdf scales 100 pixels to
1 inch.}

\item{lineLength}{Initial length of label lines in pixels.}

\item{npoints}{Maximum number of points to plot when saving to pdf. Defaults
to plot the top 1 million points by p value. Setting a value of \code{NA} will
plot all points.}

\item{nplotly}{Maximum number of points to display via plotly. We recommend
the default setting of 100,000 points (or fewer).}

\item{npeaks}{Number of peaks to label initially.}

\item{span}{a peak is defined as the most significant SNP within a window of
width span SNPs centred at that SNP. Large numbers take significantly longer.}

\item{transpose}{Logical whether to transpose the plot.}

\item{filename}{Filename for saving to pdf.}

\item{...}{Other arguments passed to \code{\link[=easylabel]{easylabel()}}.}
}
\value{
No return value
}
\description{
Interactive labelling of Manhattan plots using 'shiny' and 'plotly'
interface.
}
\seealso{
\code{\link[=easylabel]{easylabel()}} \code{\link[=easyVolcano]{easyVolcano()}}
}
