% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgm_plot_class.R
\name{structure_probs}
\alias{structure_probs}
\alias{plot_structure_probabilities}
\title{Plot Posterior Structure Probabilities}
\usage{
plot_structure_probabilities(output, as_BF = FALSE, ...)
}
\arguments{
\item{output}{Output object from the easybgm function. Supports also objects from the bgm function of the \code{bgms} package.}

\item{as_BF}{If TRUE plots the y-axis as Bayes factors instead of posterior structure probability. Default is FALSE.}

\item{...}{Additional arguments passed onto \code{ggplot2}}
}
\value{
Returns a plot
}
\description{
Plots the posterior structure probabilities of all visited structures, sorted from the most to the least probable.
}
\examples{
\donttest{

library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)
fit <- easybgm(data, type = "ordinal", save = TRUE, edge_selection = TRUE,
                iter = 1000  # for demonstration only (> 5e4 recommended)
                )

plot_structure_probabilities(fit)
}
}
