% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsIgn.R
\name{EnsIgn}
\alias{EnsIgn}
\alias{EnsIgnss}
\title{Ignorance Score}
\usage{
EnsIgn(ens, obs, type = 3, ...)

EnsIgnss(ens, ens.ref, obs, type = 3)
}
\arguments{
\item{ens}{n x j matrix of n probability forecasts for j categories}

\item{obs}{n x j matrix of occurence of n verifying observations in j 
categories}

\item{type}{selection of plotting positions to convert ensemble counts to 
probabilities (default to 3, see \code{\link{count2prob}}}

\item{...}{additional arguments for consistency with other functions (not
used)}

\item{ens.ref}{n x j matrix of n probability forecasts for j categories}
}
\description{
Computes the ignorance score \code{EnsIgn} and skill score 
  \code{EnsIgnss} for an interpretation of the ensemble as a probability 
  forecast
}
\examples{
tm <- toymodel()

## compute ignorance score for tercile forecasts
veriApply("EnsIgn", fcst=tm$fcst, obs=tm$obs, prob=1:2/3)

## compute skill score
veriApply("EnsIgnss", fcst=tm$fcst, obs=tm$obs, prob=1:2/3)

}
\references{
Wilks, D.S. (2011). Statistical methods in the atmospheric 
  sciences (Third Edition). Academic press. Jolliffe, I.T. and D.B.
  Stephenson (2012). Forecast Verification. A Practitioner's Guide in
  Atmospheric Science. Wiley-Blackwell.
}
\seealso{
\code{\link{veriApply}}, \code{\link{count2prob}}
}

