% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5create_custom_panel.R
\name{create_custom_panel}
\alias{create_custom_panel}
\title{Create custom longitudinal (panel) dataset with PSID Family Files}
\usage{
create_custom_panel(var_names, in_direc, out_direc)
}
\arguments{
\item{var_names}{Variable names to include in custom longitudinal dataset (as vector of strings)}

\item{in_direc}{Directory of PSID .rds to use for custom longitudinal dataset}

\item{out_direc}{Directory to place resulting longitudinal dataset into}
}
\description{
Uses the longitudinal PSID Family Files to create a custom longitudinal dataset in long format based on all PSID .rds Family files in a selected directory.

This function can work with data that has been renamed via the rename_fam_vars function or data just converted to .rds format via the convert_to_rds function. It will creates NAs for years when a given variable was not available, and creates a new variable ("Year") to specify the panel of data included in the custom dataset. If a provided variable exists in other waves of the family files under a different name, all waves of that variable will be included in the resulting dataset.

To create a longitudinal family file of the PSID with all variables in the PSID Family Files, it is recommended that one uses the create_extract function instead. However, such a file can be very large when using many waves of the PSID. Users with more than five waves of the PSID Family Files are highly recommended to avoid creating a longitudinal dataset with all unique Family File variables.
}
\examples{
create_custom_panel(
   var_names = c("V534", "V442", "V398"),
   in_direc=system.file("extdata","rds_dir", package = "easyPSID"),
   out_direc=tempdir()
)
}
\keyword{PSID}
