% Generated by roxygen2 (4.0.1): do not edit by hand
\name{easingAreaChart}
\alias{easingAreaChart}
\title{Credit easing data as a stacked area chart.}
\usage{
easingAreaChart(e)
}
\arguments{
\item{e}{an object of class \code{easing} as returned by \code{\link[easingr]{getEasingData}} and its many offspring.}
}
\description{
Provides a convenience function for passing an \code{easing} object to \code{xyplot} to render a sand (stacked area) chart.
}
\details{
Provides several assumptions about the display of the \code{easing} data to correspond to similar presentations at the Cleveland Fed's data site.  To implement the stacked area chart the function first computes the column-wise value accumulations, then passes these values to the \code{latticeExtra} \code{xyarea} polygon rendering tools.  Plots the columns in reverse stacking order to show the desired overlaps.
}
\examples{
es <- getEasingSummary()
easingAreaChart(es)
}
\seealso{
xyplot.easing easingLineChart getEasingData
}

