% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{cv}
\alias{cv}
\title{Function that creates customized cross-validation folds}
\usage{
cv(x, fold = 10, strata = rep(1, times = nrow(x)), shuffle = TRUE,
  seed = NULL)
}
\arguments{
\item{x}{The original data matrix or data.frame}

\item{fold}{Number of desired cross-validation folds; preferably between 3 (3-fold CV) and nrow(x) (LOO-CV)}

\item{strata}{Indicator if some strata should be balanced over the bins; if no balancing is required, the vector should consist of a single value with length equal to rows in x. Otherwise each strata/batch should be indicated as a unique member in the vector.}

\item{shuffle}{Whether the indices for the data matrix should be shuffled prior to assigning them to train/test bins}

\item{seed}{A random seed for reproducibility}
}
\description{
The function creates two matrices and returns them as members of a list. 'train' holds training sample indices, columns are cv-folds and rows are sample indices to hold as training samples in each fold. 'test' holds test/validation sample indices, columns are cv-folds and rows are sample indices to hold as test samples in each fold
}
\examples{
data(TYKSSIMU)
cvfolds <- cv(x = xMEDISIMU, fold = 3)
cvfolds$train
cvfolds$test
}
