% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psp.R
\docType{methods}
\name{PSP-methods}
\alias{PSP-methods}
\alias{print,PSP-method}
\alias{plot}
\alias{plot,PSP-method}
\alias{plot,PSP,ANY-method}
\alias{coef,PSP-method}
\alias{predict,PSP-method}
\alias{PSP.KM}
\alias{PSP.KM,PSP-method}
\alias{PSP.KM,PSP,ANY-method}
\alias{PSP.PCA}
\alias{PSP.PCA,PSP-method}
\alias{PSP.PCA,PSP,ANY-method}
\alias{PSP.BOX}
\alias{PSP.BOX,PSP-method}
\alias{PSP.BOX,PSP,ANY-method}
\alias{PSP.CSP}
\alias{PSP.CSP,PSP-method}
\alias{PSP.CSP,PSP,ANY-method}
\alias{PSP.NA}
\alias{PSP.NA,PSP-method}
\alias{PSP.NA,PSP,ANY-method}
\title{PSP-methods}
\usage{
\S4method{print}{PSP}(x, ...)

plot(x, y, ...)

\S4method{plot}{PSP}(x, y, bias = 0.1, ...)

\S4method{coef}{PSP}(object)

\S4method{predict}{PSP}(object, type = "response", newx, verb = 0)

PSP.KM(object, ...)

\S4method{PSP.KM}{PSP}(object, cutoff = 0.5)

PSP.PCA(object, ...)

\S4method{PSP.PCA}{PSP}(object, newx, expanded = TRUE, type = "all",
  shuffle = TRUE, z = TRUE, cex = 1, col = c("aquamarine", "coral",
  "royalblue", "black"), pch = 16)

PSP.BOX(object, ...)

\S4method{PSP.BOX}{PSP}(object, newx, var = colnames(object@x)[1],
  expanded = FALSE)

PSP.CSP(object, ...)

\S4method{PSP.CSP}{PSP}(object, newx, t = seq(from = 1, to = 36 * 30.5, by =
  1), plot = FALSE)

PSP.NA(object, ...)

\S4method{PSP.NA}{PSP}(object, newx, plot = TRUE)
}
\arguments{
\item{x}{Generic x}

\item{...}{Additional custom parameters passed on}

\item{y}{Generic y}

\item{bias}{Bias for skewing the color in heatmap key plotting}

\item{object}{PSP-object}

\item{type}{Types of variables to include; recognizes (int)eger, (bin)ary and (num)eric}

\item{newx}{New data matrix}

\item{verb}{Level of verbosity}

\item{cutoff}{Cutoff point for division}

\item{expanded}{Should data matrix expansion through interactions be included}

\item{shuffle}{Shuffle plotting order}

\item{z}{Should data centering and scaling should be conducted}

\item{cex}{Zooming multiplier}

\item{col}{Vector of color numbers or names to use for strata}

\item{pch}{Point type to use (refer to par-function pch-parameter)}

\item{var}{Name of variable to plot}

\item{t}{Sequence of time points to evaluate cumulative survival probabilities at}

\item{plot}{Plot the corresponding functionality}
}
\description{
PSP-methods

print.PSP: Print general information of PSPs contents to the terminal

plot.PSP: By default the mean CV surface in terms of alpha/lambda is plotted using hamlet-package's hmap-function

coef.PSP: Default PSP coef-function extracts only the optimum parameters, not whole lambda-range

predict.PSP: Predict for a novel patient from current PSP

PSP.KM: Kaplan-Meier with division at a given cutoff point within [0,1]

PSP.PCA: Principal Component Plot of a single PSP, showing 2 principal axes with a colouring if strata have been indicated; newx can also be plotted in relation to fitting data

PSP.BOX: Boxplot of a single variable in a PSP in respect to strata, for outlier detection and observing variable distributions

PSP.CSP: Cumulative survival probabilities

PSP.NA: Nelson-Aalen with time-to-event prediction at point t = F^-1(0.5)
}
\note{
Please refer to the PSP-class examples for applying these PSP-methods
}
