% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{score.iAUC}
\alias{score.iAUC}
\title{Scoring function for evaluating survival prediction by time-wise integrated AUC}
\usage{
score.iAUC(pred, time, event, real, times = seq(6, 30, by = 1) * 30.5)
}
\arguments{
\item{pred}{Numeric risk score for each event}

\item{time}{A vector of event or censoring times}

\item{event}{A binary valued vector that indicates either death (1) or right-censoring (0)}

\item{real}{A previously constructed Surv-object instead of providing time and event}

\item{times}{Time-points at which to evaluate the iAUC}
}
\value{
The integrated area under the ROC-curve over time
}
\description{
Time-wise integrated prediction for survival is performed by this scoring function using the timeROC-package. 
It's offered as an alternative to the score.cindex-function with the difference that time-wise integrated AUC is sensitive to the choice of time-window. 
By default (as similar to DREAM 9.5 mCRPC challenge), the AUCs are determined at 6 to 30 months, and the AUC is then normalized to a score within [0,1]. Notice that for studies shorter or longer than this proposed time window, the scoring function should be adjusted accordingly.
}
\examples{
# A random prediction ought to be near 0.5 
# iAUC is sensitive to the choice of time points to test AUC at
set.seed(1); prediction <- sample(1:20)
time <- seq(from=1000, to=50, by=-50)
event <- c(0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1)
library(survival)
score.iAUC(pred = prediction, real = Surv(time=time, event=event))
}
