% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_create_ti_method_definition.R
\name{create_ti_method_definition}
\alias{create_ti_method_definition}
\title{Create a TI method from a local method definition file}
\usage{
create_ti_method_definition(definition, script, return_function = TRUE)
}
\arguments{
\item{definition}{A definition, see \code{\link[=definition]{definition()}}}

\item{script}{Location of the script that will be executed. Has to contain a #!}

\item{return_function}{Whether to return a function that allows you to override the default parameters, or just return the method meta data as is.}
}
\value{
A function that can be used to adapt the parameters of the method. This functions returns a list containing all metadata of the method, and can be used to \link[=infer_trajectory]{infer a trajectory}
}
\description{
The local method definition file describes a method that is runnable on the local system.
See \href{../doc/create_ti_method_definition.html}{\code{vignette("create_ti_method_definition", "dynwrap")}} for a tutorial on how to create a containerized TI method.
}
\examples{

# See the vignette "create_ti_method_definition" to get a good idea on how
# to use this function.

# create a definition.yaml file and a run.R/py script.
# method <- create_ti_method_definition("definition.yml", "run.R")
# trajectory <- infer_trajectory(example_dataset, method(), verbose = TRUE)

}
\keyword{create_ti_method}
