% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynatop.R
\name{dynatop}
\alias{dynatop}
\title{R6 Class for Dynamic TOPMODEL}
\description{
R6 Class for Dynamic TOPMODEL

R6 Class for Dynamic TOPMODEL
}
\examples{
## the vignettes contains further details of the method calls.

data("Swindale") ## example data
ctch_mdl <- dynatop$new(Swindale$model) ## create with model
ctch_mdl$add_data(Swindale$obs) ## add observations
ctch_mdl$initialise() ## initialise model
ctch_mdl$sim() ## simulate model
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{dynatop$new()}}
\item \href{#method-add_data}{\code{dynatop$add_data()}}
\item \href{#method-clear_data}{\code{dynatop$clear_data()}}
\item \href{#method-initialise}{\code{dynatop$initialise()}}
\item \href{#method-sim_hillslope}{\code{dynatop$sim_hillslope()}}
\item \href{#method-sim_channel}{\code{dynatop$sim_channel()}}
\item \href{#method-sim}{\code{dynatop$sim()}}
\item \href{#method-get_channel_inflow}{\code{dynatop$get_channel_inflow()}}
\item \href{#method-plot_channel_inflow}{\code{dynatop$plot_channel_inflow()}}
\item \href{#method-get_gauge_flow}{\code{dynatop$get_gauge_flow()}}
\item \href{#method-plot_gauge_flow}{\code{dynatop$plot_gauge_flow()}}
\item \href{#method-get_obs_data}{\code{dynatop$get_obs_data()}}
\item \href{#method-get_model}{\code{dynatop$get_model()}}
\item \href{#method-get_mass_errors}{\code{dynatop$get_mass_errors()}}
\item \href{#method-get_states}{\code{dynatop$get_states()}}
\item \href{#method-plot_state}{\code{dynatop$plot_state()}}
\item \href{#method-clone}{\code{dynatop$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a dynatop class object from the a list based model description as generated by dynatopGIS.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$new(model, use_states = FALSE, delta = 1e-13)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{a dynamic TOPMODEL list object}

\item{\code{use_states}}{logical if states should be imported}

\item{\code{delta}}{error term in checking redistribution sums}

\item{\code{drop_map}}{logical if the map should be dropped}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function makes some basic consistency checks on a list representing a dynamic TOPMODEL model. The checks performed and basic 'sanity' checks. They do not check for the logic of the parameter values nor the consistncy of states and parameters. Sums of the redistribution matrices are checked to be in the range 1 +/- delta.
}

\subsection{Returns}{
invisible(self) suitable for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-add_data}{}}}
\subsection{Method \code{add_data()}}{
Adds observed data to a dynatop object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$add_data(obs_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obs_data}}{an xts object of observed data}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function makes some basic consistency checks on the observations to ensure they have uniform timestep and all required series are present.
}

\subsection{Returns}{
invisible(self) suitable for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_data"></a>}}
\if{latex}{\out{\hypertarget{method-clear_data}{}}}
\subsection{Method \code{clear_data()}}{
Clears all forcing and simulation data except current states
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$clear_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisible(self) suitable for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-initialise"></a>}}
\if{latex}{\out{\hypertarget{method-initialise}{}}}
\subsection{Method \code{initialise()}}{
Initialises a dynatop object in the simpliest way possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$initialise(tol = 2 * .Machine$double.eps, max_it = 1000)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tol}}{tolerance for the solution for the saturated zone}

\item{\code{max_it}}{maximum number of iterations to use in the solution of the saturated zone}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible(self) suitable for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim_hillslope"></a>}}
\if{latex}{\out{\hypertarget{method-sim_hillslope}{}}}
\subsection{Method \code{sim_hillslope()}}{
Simulate the hillslope output of a dynatop object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$sim_hillslope(
  keep_states = NULL,
  sub_step = NULL,
  tol = 2 * .Machine$double.eps,
  max_it = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keep_states}}{a vector of POSIXct objects (e.g. from xts) giving the time stamp at which the states should be kept}

\item{\code{sub_step}}{simulation timestep in seconds, default value of NULL results in data time step}

\item{\code{tol}}{tolerance for the solution for the saturated zone}

\item{\code{max_it}}{maximum number of iterations to use in the solution of the saturated zone}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Both saving the states at every timestep and keeping the mass balance can generate very large data sets!!
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim_channel"></a>}}
\if{latex}{\out{\hypertarget{method-sim_channel}{}}}
\subsection{Method \code{sim_channel()}}{
Simulate the channel output of a dynatop object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$sim_channel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisible(self) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim"></a>}}
\if{latex}{\out{\hypertarget{method-sim}{}}}
\subsection{Method \code{sim()}}{
Simulate the hillslope and channel componets of a dynatop object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$sim(
  keep_states = NULL,
  sub_step = NULL,
  tol = 2 * .Machine$double.eps,
  max_it = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keep_states}}{a vector of POSIXct objects (e.g. from xts) giving the time stamp at which the states should be kept}

\item{\code{sub_step}}{simulation timestep in seconds, default value of NULL results in data time step}

\item{\code{tol}}{tolerance for the solution for the saturated zone}

\item{\code{max_it}}{maximum number of iterations to use in the solution of the saturated zone}

\item{\code{mass_check}}{Flag indicating is a record of mass balance errors shuld be kept}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Calls the sim_hillslope and sim_channel in sequence. Both saving the states at every timestep and keeping the mass balance can generate very large data sets!!
}

\subsection{Returns}{
invisible(self) for chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_channel_inflow"></a>}}
\if{latex}{\out{\hypertarget{method-get_channel_inflow}{}}}
\subsection{Method \code{get_channel_inflow()}}{
Return channel inflow as an xts series or list of xts series
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_channel_inflow(total = FALSE, separate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{total}}{logical if plot total inflow is to be plotted}

\item{\code{separate}}{logical if the surface and saturated zone inflows should be returned separately}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_channel_inflow"></a>}}
\if{latex}{\out{\hypertarget{method-plot_channel_inflow}{}}}
\subsection{Method \code{plot_channel_inflow()}}{
Plot the channel inflow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$plot_channel_inflow(total = FALSE, separate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{total}}{logical if total inflow is to be plotted}

\item{\code{separate}}{logical logical if the surface and saturated zone inflows should be plotted separately}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_gauge_flow"></a>}}
\if{latex}{\out{\hypertarget{method-get_gauge_flow}{}}}
\subsection{Method \code{get_gauge_flow()}}{
Return flow at the gauges as an xts series
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_gauge_flow(gauge = colnames(private$time_series$gauge_flow))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gauge}}{names of gauges to return (default is all gauges)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_gauge_flow"></a>}}
\if{latex}{\out{\hypertarget{method-plot_gauge_flow}{}}}
\subsection{Method \code{plot_gauge_flow()}}{
Get the flow at gauges
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$plot_gauge_flow(gauge = colnames(private$time_series$gauge_flow))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gauge}}{names of gauges to return (default is all gauges)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_obs_data"></a>}}
\if{latex}{\out{\hypertarget{method-get_obs_data}{}}}
\subsection{Method \code{get_obs_data()}}{
Get the observed data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_obs_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_model"></a>}}
\if{latex}{\out{\hypertarget{method-get_model}{}}}
\subsection{Method \code{get_model()}}{
Return the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_model()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_mass_errors"></a>}}
\if{latex}{\out{\hypertarget{method-get_mass_errors}{}}}
\subsection{Method \code{get_mass_errors()}}{
Return the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_mass_errors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_states"></a>}}
\if{latex}{\out{\hypertarget{method-get_states}{}}}
\subsection{Method \code{get_states()}}{
Return states
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$get_states(record = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{record}}{logical TRUE if the record should be returned. Otherwise the current states returned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_state"></a>}}
\if{latex}{\out{\hypertarget{method-plot_state}{}}}
\subsection{Method \code{plot_state()}}{
Plot a current state of the system
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$plot_state(state, add_channel = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{the name of the state to be plotted}

\item{\code{add_channel}}{Logical indicating if the channel should be added to the plot}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dynatop$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
