
t1a <- runif(100,min=0,max=1)
t2a <- runif(100,min=0.7,max=1)
S1 <- data.frame(Species="A", t1a, t2a)
t2a<-c(t2a[1:100]-0.31)
S2 <- data.frame(Species="B", t1a, t2a)
A <- rbind(S1, S2)
  
r<-dynRB_VPa(A, correlogram = FALSE)
  
expect_equal(c(1,0,0,1),r$result[,3])

  
#############################

t1a <- runif(100,min=0,max=1)
t2a <- runif(100,min=0,max=1)
S1 <- data.frame(Species="A", t1a, t2a)
S2 <- data.frame(Species="B", t1a, t2a)
A <- rbind(S1, S2)

r<-dynRB_VPa(A, correlogram = FALSE)

expect_equal(c(1,1,1,1),r$result[,3])

  
#############################

t1a <- c(rnorm(100,mean=0.3,sd=0.05),rnorm(100,mean=0.7,sd=0.05))
t2a <- c(rnorm(100,mean=0.3,sd=0.05),rnorm(100,mean=0.7,sd=0.05))
S1 <- data.frame(Species="A", x=t1a, y=t2a)
S2 <- data.frame(Species="B", x=t1a, y=t2a)
A <- rbind(S1, S2)

r<-dynRB_VPa(A, correlogram = FALSE)

expect_equal(c(1,1,1,1),r$result[,3])
  

#############################


t1a <- runif(1000,min=0,max=1)
t2a <- runif(1000,min=0.4,max=1)
t3a <- t1a[t2a<0.7]
t4a <- t2a[t2a<0.7]-0.02
t1a <- t1a[t2a>=0.7]
t2a <- t2a[t2a>=0.7]
S1 <- data.frame(Species="A", t1a=c(t1a,t3a), t2a=c(t2a,t4a))
S2 <- data.frame(Species="B", t1a=t3a, t2a=t4a)
A <- rbind(S1, S2)

r<-dynRB_VPa(A, correlogram = FALSE)
x <- as.numeric(r$result[,6] > c(0.95,0.45,0.95,0.45) & r$result[,6] <= c(1,0.51,1,0.51))

expect_equal(c(1,1,1,1),x)


############################


t1a <- c(runif(100,min=0,max=1),runif(0,min=0,max=0.1))
t2a <- c(runif(100,min=0.7,max=1),runif(0,min=0,max=0.1))
S1 <- data.frame(Species="A", t1a, t2a)
t2a<-c(t2a[1:100]-0.3)
S2 <- data.frame(Species="B", t1a, t2a)

A <- rbind(S1, S2)

#---

t3a <- c(runif(100,min=0,max=1),runif(0,min=0,max=0.1))
t4a <- c(runif(100,min=0,max=1),runif(0,min=0,max=0.1))

S1 <- data.frame(Species="A", t3a, t4a)
S2 <- data.frame(Species="B", t3a, t4a)

B <- rbind(S1, S2)
C<-cbind(A,B[,2:3])

A<-C

r<-dynRB_VPa(A, correlogram = FALSE)
expect_equal(c(1,0,0,1),r$result[,3])


#############################


# two normal distributions

x <- c(0.469, 0.462, 0.437, 0.565, 0.511, 0.396, 0.533, 0.562, 0.708, 0.626, 0.358, 0.471, 0.509, 0.569,
 0.570, 0.464, 0.339, 0.696, 0.595, 0.620, 0.642, 0.492, 0.757, 0.438, 0.348, 0.530, 0.513, 0.381,
 0.542, 0.526, 0.544, 0.421, 0.394, 0.322, 0.473, 0.446, 0.628, 0.561, 0.537, 0.587, 0.405, 0.614,
 0.427, 0.746, 0.694, 0.592, 0.606, 0.560, 0.645, 0.445, 0.665, 0.502, 0.586, 0.469, 0.382, 0.565,
 0.548, 0.412, 0.640, 0.457, 0.652, 0.431, 0.554, 0.437, 0.316, 0.613, 0.446, 0.370, 0.623, 0.591,
 0.550, 0.295, 0.548, 0.475, 0.379, 0.554, 0.450, 0.620, 0.452, 0.425, 0.409, 0.554, 0.370, 0.498,
 0.442, 0.617, 0.401, 0.415, 0.518, 0.484, 0.654, 0.352, 0.563, 0.467, 0.513, 0.572, 0.365, 0.461,
 0.585, 0.447, 0.468, 0.339, 0.656, 0.396, 0.509, 0.484, 0.492, 0.395, 0.479, 0.580, 0.844, 0.420,
 0.450, 0.426, 0.416, 0.611, 0.287, 0.446, 0.499, 0.370, 0.486, 0.351, 0.517, 0.470, 0.339, 0.610,
 0.307, 0.557, 0.583, 0.461, 0.541, 0.343, 0.615, 0.470, 0.435, 0.571, 0.543, 0.566, 0.610, 0.515,
 0.485, 0.534, 0.590, 0.565, 0.576, 0.614, 0.549, 0.569, 0.511, 0.628, 0.515, 0.536, 0.530, 0.359,
 0.556, 0.662, 0.426, 0.511, 0.399, 0.453, 0.479, 0.345, 0.365, 0.565, 0.333, 0.643, 0.630, 0.502,
 0.522, 0.579, 0.589, 0.664, 0.491, 0.401, 0.597, 0.651, 0.450, 0.376, 0.615, 0.623, 0.291, 0.478,
 0.575, 0.468, 0.493, 0.573, 0.395, 0.501, 0.338, 0.273, 0.464, 0.528, 0.558, 0.630, 0.309, 0.539,
 0.499, 0.461, 0.480, 0.500, 0.472, 0.507, 0.508, 0.496, 0.477, 0.501, 0.488, 0.502, 0.504, 0.491,
 0.492, 0.489, 0.480, 0.492, 0.480, 0.515, 0.495, 0.517, 0.496, 0.495, 0.511, 0.492, 0.487, 0.500,
 0.483, 0.505, 0.493, 0.493, 0.488, 0.527, 0.536, 0.518, 0.477, 0.513, 0.490, 0.503, 0.509, 0.499,
 0.494, 0.490, 0.510, 0.516, 0.498, 0.515, 0.521, 0.512, 0.478, 0.520, 0.501, 0.471)

y <- c(0.452, 0.446, 0.560, 0.444, 0.326, 0.529, 0.604, 0.696, 0.396, 0.553, 0.602, 0.615, 0.330, 0.469, 0.462, 0.609, 0.823,
 0.615, 0.463, 0.622, 0.394, 0.438, 0.572, 0.441, 0.503, 0.535, 0.543, 0.531, 0.589, 0.560, 0.434, 0.387, 0.510, 0.366,
 0.397, 0.513, 0.592, 0.381, 0.473, 0.438, 0.506, 0.604, 0.447, 0.302, 0.586, 0.537, 0.603, 0.587, 0.346, 0.502, 0.436,
 0.334, 0.525, 0.401, 0.406, 0.443, 0.511, 0.466, 0.443, 0.806, 0.632, 0.620, 0.408, 0.502, 0.575, 0.578, 0.373, 0.470,
 0.442, 0.468, 0.584, 0.599, 0.443, 0.624, 0.441, 0.360, 0.385, 0.493, 0.522, 0.590, 0.509, 0.422, 0.211, 0.563, 0.683,
 0.509, 0.648, 0.614, 0.461, 0.488, 0.370, 0.487, 0.494, 0.506, 0.379, 0.448, 0.549, 0.479, 0.500, 0.553, 0.528, 0.439,
 0.493, 0.504, 0.485, 0.609, 0.511, 0.468, 0.413, 0.353, 0.535, 0.476, 0.552, 0.670, 0.542, 0.418, 0.477, 0.581, 0.447,
 0.535, 0.394, 0.518, 0.463, 0.586, 0.470, 0.545, 0.646, 0.415, 0.389, 0.474, 0.442, 0.644, 0.656, 0.582, 0.503, 0.465,
 0.465, 0.535, 0.481, 0.589, 0.337, 0.293, 0.454, 0.401, 0.487, 0.487, 0.394, 0.406, 0.462, 0.343, 0.390, 0.678, 0.453,
 0.424, 0.548, 0.721, 0.479, 0.428, 0.318, 0.396, 0.562, 0.263, 0.545, 0.223, 0.371, 0.620, 0.599, 0.549, 0.374, 0.360,
 0.604, 0.350, 0.346, 0.478, 0.558, 0.641, 0.425, 0.713, 0.436, 0.402, 0.470, 0.369, 0.490, 0.573, 0.498, 0.730, 0.440,
 0.513, 0.487, 0.564, 0.517, 0.477, 0.659, 0.707, 0.478, 0.472, 0.511, 0.481, 0.374, 0.479, 0.497, 0.509, 0.500, 0.488,
 0.456, 0.510, 0.500, 0.489, 0.490, 0.502, 0.511, 0.481, 0.503, 0.474, 0.505, 0.526, 0.507, 0.490, 0.487, 0.502, 0.501,
 0.505, 0.494, 0.512, 0.489, 0.489, 0.497, 0.514, 0.514, 0.528, 0.506, 0.485, 0.491, 0.501, 0.487, 0.505, 0.510, 0.473,
 0.527, 0.515, 0.511, 0.476, 0.489, 0.519, 0.492, 0.494, 0.491, 0.471, 0.495, 0.510)
     
 
S1 <- data.frame(Species="A", x=x[1:200], y=y[1:200])
S2 <- data.frame(Species="B", x=x[201:250], y=y[201:250])
 
A <- rbind(S1, S2)

r<-dynRB_VPa(A, correlogram = FALSE)
x <- as.numeric(r$result[2:3,3] > c(0,0.95) & r$result[2:3,3] <= c(0.05,1))

expect_equal(c(1,1),x)






 