/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.painter.ControlBackgroundComposite;

public class DecayControlBackgroundComposite
extends ControlBackgroundComposite {
    public Composite getBackgroundComposite(Component component, Container container, int componentIndex, boolean isPaintedActive) {
        if (isPaintedActive) {
            return AlphaComposite.SrcOver;
        }
        if (container instanceof JTabbedPane && componentIndex >= 0) {
            JTabbedPane tabPane = (JTabbedPane)container;
            SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabPane.getUI();
            Rectangle tabRect = ui.getTabRectangle(componentIndex);
            Rectangle selectedTabRect = ui.getTabRectangle(tabPane.getSelectedIndex());
            int dx = selectedTabRect.x + selectedTabRect.width / 2 - tabRect.x - tabRect.width / 2;
            int dy = selectedTabRect.y + selectedTabRect.height / 2 - tabRect.y - tabRect.height / 2;
            double dist = Math.pow(dx * dx + dy * dy, 0.3);
            double decay = 1.0 - Math.log(1.0 + dist) / 7.0;
            if (decay < 0.2) {
                decay = 0.2;
            }
            return AlphaComposite.getInstance(3, (float)decay);
        }
        return AlphaComposite.SrcOver;
    }
}

