/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import tablelayout.TableLayout;
import tablelayout.TableVecRec;

public abstract class TableVec {
    private static final String version_id = "@(#)$Id: TableVec.java,v 1.2 2002/03/26 18:21:02 tonyj Exp $ Copyright West Consulting bv";
    static final int TBL_VEC_MINIMIZE = 1;
    static final int TBL_VEC_LOCK = 2;
    static final int TBL_VEC_NOGROW = 3;
    static final boolean DO_ACTUAL = true;
    static final boolean DO_PREFERRED = false;
    public TableVecRec[] vec;
    public TableLayout parent;
    public int size;

    public abstract void minimize();

    public abstract int totalSize();

    public abstract int getPreferredSize();

    public abstract int layoutSize(boolean var1);

    public TableVecRec elementAt(int index) {
        if (index < 0 || index > this.size - 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.vec[index];
    }

    public void adjust(int change) {
        int amt;
        int vec_inx;
        if (0 == change) {
            return;
        }
        int can_change_pref = 0;
        int can_change = 0;
        int total_pref = 0;
        int too_big_pref = 0;
        int too_big = 0;
        int too_small = 0;
        for (vec_inx = 0; vec_inx < this.size; ++vec_inx) {
            total_pref += this.vec[vec_inx].pref_value;
            if (change > 0) {
                if (0 == (this.vec[vec_inx].options & 2)) {
                    ++can_change;
                    can_change_pref += this.vec[vec_inx].pref_value;
                }
                if (this.vec[vec_inx].value >= this.vec[vec_inx].pref_value) continue;
                ++too_small;
                continue;
            }
            if (this.vec[vec_inx].value <= this.vec[vec_inx].pref_value) continue;
            ++too_big;
            too_big_pref += this.vec[vec_inx].pref_value;
        }
        if (change > 0) {
            int amt2;
            int remaining = change;
            int still_too_small = 1;
            while (still_too_small != 0) {
                still_too_small = 0;
                for (vec_inx = 0; vec_inx < this.size; ++vec_inx) {
                    if (this.vec[vec_inx].value >= this.vec[vec_inx].pref_value) continue;
                    amt2 = 0 == total_pref ? change / (too_small != 0 ? too_small : this.size) : change * this.vec[vec_inx].pref_value / total_pref;
                    if (0 == amt2) {
                        amt2 = 1;
                    } else if (remaining < amt2) {
                        amt2 = remaining;
                    }
                    if (this.vec[vec_inx].value + amt2 < this.vec[vec_inx].pref_value) {
                        this.vec[vec_inx].value += amt2;
                        ++still_too_small;
                    } else {
                        amt2 = this.vec[vec_inx].pref_value - this.vec[vec_inx].value;
                        this.vec[vec_inx].value = this.vec[vec_inx].pref_value;
                    }
                    if ((remaining -= amt2) > 0) continue;
                    return;
                }
                change = remaining;
            }
            if (0 == can_change) {
                can_change_pref = total_pref;
            }
            while (true) {
                for (vec_inx = 0; vec_inx < this.size; ++vec_inx) {
                    if (0 != can_change && 0 != (this.vec[vec_inx].options & 2)) continue;
                    amt2 = 0 == can_change_pref ? change / (can_change != 0 ? can_change : this.size) : change * this.vec[vec_inx].pref_value / can_change_pref;
                    if (0 == amt2) {
                        amt2 = 1;
                    } else if (remaining < amt2) {
                        amt2 = remaining;
                    }
                    this.vec[vec_inx].value += amt2;
                    if ((remaining -= amt2) > 0) continue;
                    return;
                }
                change = remaining;
            }
        }
        int remaining = change = -change;
        int still_too_big = too_big;
        while (still_too_big != 0) {
            still_too_big = 0;
            for (vec_inx = 0; vec_inx < this.size; ++vec_inx) {
                if (this.vec[vec_inx].value <= this.vec[vec_inx].pref_value) continue;
                amt = 0 == too_big_pref ? change / (too_big != 0 ? too_big : this.size) : change * this.vec[vec_inx].pref_value / too_big_pref;
                if (0 == amt) {
                    amt = 1;
                } else if (remaining < amt) {
                    amt = remaining;
                }
                if (this.vec[vec_inx].value - amt < this.vec[vec_inx].pref_value) {
                    amt = this.vec[vec_inx].value - this.vec[vec_inx].pref_value;
                    this.vec[vec_inx].value = this.vec[vec_inx].pref_value;
                } else {
                    this.vec[vec_inx].value -= amt;
                    ++still_too_big;
                }
                if ((remaining -= amt) > 0) continue;
                return;
            }
            change = remaining;
        }
        int num_larger_than_1 = 1;
        while (num_larger_than_1 != 0) {
            num_larger_than_1 = 0;
            for (vec_inx = 0; vec_inx < this.size; ++vec_inx) {
                amt = 0 == total_pref ? change / this.size : change * this.vec[vec_inx].pref_value / total_pref;
                if (0 == amt) {
                    amt = 1;
                } else if (remaining < amt) {
                    amt = remaining;
                }
                if (amt < this.vec[vec_inx].value) {
                    this.vec[vec_inx].value -= amt;
                    ++num_larger_than_1;
                } else {
                    amt = this.vec[vec_inx].value - 1;
                    this.vec[vec_inx].value = 1;
                }
                if ((remaining -= amt) > 0) continue;
                return;
            }
            change = remaining;
        }
    }

    public void computeOffsets(int margin, int gap) {
        int offset = margin;
        for (int i = 0; i < this.size; ++i) {
            this.vec[i].offset = offset;
            offset = offset + this.vec[i].value + gap;
        }
    }

    public String toString() {
        String st = new String("TableVec [ size " + this.size);
        for (int i = 0; i < this.size; ++i) {
            st = st + "\n" + this.vec[i].toString();
        }
        st = st + " ]";
        return st;
    }
}

