/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class DateModel {
    private Vector listeners = new Vector();
    private Calendar date;

    DateModel(Calendar date) {
        this.date = date;
    }

    DateModel(Date date) {
        this.date = Calendar.getInstance();
        this.date.setTime(date);
    }

    synchronized void addDateListener(DateListener l) {
        this.listeners.addElement(l);
    }

    synchronized void removeDateListener(DateListener l) {
        this.listeners.removeElement(l);
    }

    synchronized void fireDateChanged() {
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            DateListener l = (DateListener)e.nextElement();
            l.dateChanged();
        }
    }

    void set(int field, int value) {
        this.date.set(field, value);
        this.fireDateChanged();
    }

    void roll(int field, boolean up) {
        this.date.roll(field, up);
        this.fireDateChanged();
    }

    void add(int field, int delta) {
        this.date.add(field, delta);
        this.fireDateChanged();
    }

    int get(int field) {
        return this.date.get(field);
    }

    Calendar getCalendar() {
        return this.date;
    }

    int getDaysInMonth() {
        return this.date.getActualMaximum(5);
    }

    Date getTime() {
        return this.date.getTime();
    }
}

