/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.KeyedValue;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.experimental.data.xy.VectorDataItem;
import org.jfree.experimental.data.xy.VectorSeries;
import org.jfree.experimental.data.xy.VectorXYDataset;
import org.jfree.util.ObjectUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorSeriesCollection
extends AbstractXYDataset
implements VectorXYDataset,
Serializable {
    private static final long serialVersionUID = 7823224514793680345L;
    private List<VectorSeries> data = new ArrayList<VectorSeries>();

    public void addSeries(VectorSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public VectorSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.data.get(series);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public double getXValue(int series, int item) {
        VectorSeries s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getXValue();
    }

    @Override
    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    @Override
    public double getYValue(int series, int item) {
        VectorSeries s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getYValue();
    }

    @Override
    public Number getY(int series, int item) {
        return new Double(this.getYValue(series, item));
    }

    @Override
    public Number getDeltaX(int series, int item) {
        return new Double(this.getDeltaXValue(series, item));
    }

    @Override
    public double getDeltaXValue(int series, int item) {
        VectorSeries s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getDeltaX();
    }

    @Override
    public Number getDeltaY(int series, int item) {
        return new Double(this.getDeltaYValue(series, item));
    }

    @Override
    public double getDeltaYValue(int series, int item) {
        VectorSeries s = this.data.get(series);
        VectorDataItem di = (VectorDataItem)s.getDataItem(item);
        return di.getDeltaY();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorSeriesCollection)) {
            return false;
        }
        VectorSeriesCollection that = (VectorSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VectorSeriesCollection clone = (VectorSeriesCollection)super.clone();
        clone.data = this.data;
        return clone;
    }

    @Override
    public int getIndex(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        int i = 0;
        for (KeyedValue keyedValue : this.data) {
            if (keyedValue.getKey().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Comparable getKey(int index) {
        Comparable result = null;
        KeyedValue item = (KeyedValue)((Object)this.data.get(index));
        if (item != null) {
            result = item.getKey();
        }
        return result;
    }

    @Override
    public List<VectorSeries> getKeys() {
        return this.data;
    }

    @Override
    public Number getValue(Comparable key) {
        int index = this.getIndex(key);
        if (index < 0) {
            throw new UnknownKeyException("Key not found: " + key);
        }
        return this.getValue(index);
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    @Override
    public Number getValue(int item) {
        Number result = null;
        KeyedValue kval = (KeyedValue)((Object)this.data.get(item));
        if (kval != null) {
            result = kval.getValue();
        }
        return result;
    }
}

