/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Continue;
import don.Groupe;
import don.Verifiable;
import exceptions.ExceptionIntegrite;
import java.io.Serializable;
import java.util.HashMap;
import org.jfree.chart.annotations.XYIDAnnotation;
import org.jfree.ui.TextAnchor;

public abstract class DonneeID
implements Serializable,
Verifiable {
    private String m_annotation;
    private Groupe m_gr;
    private double[] m_coord;
    private HashMap<Continue, HashMap<Continue, Double>> m_coord_annotX;
    private HashMap<Continue, HashMap<Continue, Double>> m_coord_annotY;
    private double[] m_cos2;
    private double[] m_contrib;
    private boolean m_active;
    private TextAnchor m_anchor;

    public DonneeID(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib) {
        this.m_annotation = annotation;
        this.m_active = active;
        this.m_gr = gr;
        this.m_coord = coord;
        this.m_cos2 = cos2;
        this.m_contrib = contrib;
        if (this.m_coord != null) {
            this.calcCoordAnnotDefaut();
        }
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean active) {
        this.m_active = active;
    }

    public String getAnnotation() {
        return this.m_annotation;
    }

    public void setAnnotation(String annotation) {
        this.m_annotation = annotation;
    }

    public double getContrib(int num) {
        return this.m_contrib[num];
    }

    public void setContrib(double[] contrib) {
        this.m_contrib = contrib;
        this.calcCoordAnnotDefaut();
    }

    public double getCoord(int num) {
        return this.m_coord[num];
    }

    public double getCoord(Continue c) {
        return c.getValeur(this);
    }

    public void setCoord(double[] coord) {
        this.m_coord = coord;
        this.calcCoordAnnotDefaut();
    }

    private void calcCoordAnnotDefaut() {
        this.m_coord_annotX = new HashMap();
        this.m_coord_annotY = new HashMap();
    }

    public double getCos2(int num) {
        if (this.m_cos2 == null) {
            return 0.0;
        }
        return this.m_cos2[num];
    }

    public void setCos2(double[] cos2) {
        this.m_cos2 = cos2;
        this.calcCoordAnnotDefaut();
    }

    public Groupe getGr() {
        return this.m_gr;
    }

    public double getXannot(Continue axeX, Continue axeY) {
        Double xannot = null;
        HashMap<Continue, Double> hashMap = this.m_coord_annotX.get(axeX);
        if (hashMap != null) {
            xannot = hashMap.get(axeY);
        }
        if (xannot == null) {
            xannot = axeX.getValeur(this);
            this.setXannot(axeX, axeY, xannot);
        }
        return xannot;
    }

    public double getYannot(Continue axeX, Continue axeY) {
        Double yannot = null;
        HashMap<Continue, Double> hashMap = this.m_coord_annotY.get(axeX);
        if (hashMap != null) {
            yannot = hashMap.get(axeY);
        }
        if (yannot == null) {
            yannot = axeY.getValeur(this);
            this.setYannot(axeX, axeY, yannot);
        }
        return yannot;
    }

    public TextAnchor getAnchor() {
        if (this.m_anchor == null) {
            return XYIDAnnotation.DEFAULT_TEXT_ANCHOR;
        }
        return this.m_anchor;
    }

    public void setXYannot(Continue axeX, Continue axeY, double xannot, double yannot, TextAnchor anchor) {
        this.setXannot(axeX, axeY, xannot);
        this.setYannot(axeX, axeY, yannot);
        this.m_anchor = anchor;
    }

    private void setYannot(Continue axeX, Continue axeY, double yannot) {
        HashMap<Continue, Double> tab = this.m_coord_annotY.get(axeX);
        if (tab == null) {
            tab = new HashMap();
            this.m_coord_annotY.put(axeX, tab);
        }
        tab.put(axeY, yannot);
    }

    private void setXannot(Continue axeX, Continue axeY, double xannot) {
        HashMap<Continue, Double> tab = this.m_coord_annotX.get(axeX);
        if (tab == null) {
            tab = new HashMap();
            this.m_coord_annotX.put(axeX, tab);
        }
        tab.put(axeY, xannot);
    }

    public void setGr(Groupe gr) {
        if (!gr.getDonneesID().contains(this)) {
            gr.addDonneesID(this);
        }
        this.m_gr = gr;
    }

    public String toString() {
        String chaine = String.valueOf(this.getClass().getSimpleName()) + " " + this.m_annotation;
        chaine = this.m_active ? String.valueOf(chaine) + " actif/ve" : String.valueOf(chaine) + " illustratif/ve";
        chaine = this.m_gr != null ? String.valueOf(chaine) + " (" + this.m_gr.getNum() + ")" : String.valueOf(chaine) + " (pas de groupe)";
        return chaine;
    }

    public void verifierIntegrite() throws ExceptionIntegrite {
        String type = "(" + this.getClass().getSimpleName() + ")";
        if (this.m_annotation == null) {
            throw new ExceptionIntegrite("donn\u00e9e " + type + " sans annotation");
        }
        if (!(this instanceof Groupe)) {
            if (this.m_gr == null) {
                throw new ExceptionIntegrite("donn\u00e9e " + type + " sans groupe : " + this.m_annotation);
            }
            if (this.m_gr.getDonneesID() != null) {
                if (!this.m_gr.getDonneesID().contains(this)) {
                    this.m_gr.addDonneesID(this);
                }
            } else {
                this.m_gr.addDonneesID(this);
            }
        }
    }
}

