/*
 * Decompiled with CFR 0.152.
 */
package actions;

import don.AxePartiel;
import don.DonneeID;
import don.Qualifiable;
import ihm.Gestionnaire;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Timer;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import outils.Constantes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelMouseActionListener
implements ChartMouseListener,
ActionListener {
    private static final int m_marge = Constantes.FORME_INDIVIDUS.getBounds().width + 4;
    private Gestionnaire m_gest;
    private ChartPanel m_panel;
    private Timer timer;
    private Qualifiable m_qualifiableSousSouris;
    private Object m_habillage;

    public PanelMouseActionListener(Gestionnaire gestionnaire, ChartPanel panel) {
        this.m_gest = gestionnaire;
        this.m_panel = panel;
        this.timer = new Timer(300, this);
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getTrigger().getClickCount() > 1) {
            this.timer.stop();
            Vector<DonneeID> res = this.getDonneeIDs(event);
            if (res.size() > 0) {
                this.m_gest.setAnnotations(res, !this.m_gest.isAnnotations(res));
            }
        } else {
            Qualifiable qualif = this.getQualifiable(event);
            this.demarrerAttente(qualif);
        }
    }

    private Qualifiable getQualifiable(ChartMouseEvent event) {
        Qualifiable qualif = null;
        Rectangle2D rect = this.getRect(event);
        if (this.m_gest.getCanvas().contientX(this.m_panel, rect, 0.0) || this.m_gest.getCanvas().bordVertical(this.m_panel, rect)) {
            qualif = this.m_gest.getAxeY();
        } else if (this.m_gest.getCanvas().contientY(this.m_panel, rect, 0.0) || this.m_gest.getCanvas().bordHorizontal(this.m_panel, rect)) {
            qualif = this.m_gest.getAxeX();
        } else {
            Vector<DonneeID> liste = this.m_gest.getCanvas().findPoint(this.m_panel, rect);
            for (DonneeID donneeID : liste) {
                if (!(donneeID instanceof Qualifiable) || donneeID instanceof AxePartiel) continue;
                qualif = (Qualifiable)((Object)donneeID);
            }
        }
        return qualif;
    }

    private Rectangle2D getRectConfiance(ChartMouseEvent event) {
        Point2D point = this.m_panel.translateScreenToJava2D(event.getTrigger().getPoint());
        int x = (int)point.getX();
        int y = (int)point.getY();
        Rectangle2D.Double rect = new Rectangle2D.Double(x - m_marge, y - m_marge, m_marge * 2, m_marge * 2);
        return rect;
    }

    private Vector<DonneeID> getDonneeIDs(ChartMouseEvent event) {
        Vector<DonneeID> res = new Vector<DonneeID>();
        Rectangle2D rect = this.getRect(event);
        if (rect != null) {
            res = this.m_gest.getCanvas().findPoint(this.m_panel, rect);
        }
        return res;
    }

    private Rectangle2D getRect(ChartMouseEvent event) {
        ChartEntity chartEntity = event.getEntity();
        Rectangle2D rect = null;
        if (chartEntity instanceof XYItemEntity) {
            XYItemEntity entity = (XYItemEntity)chartEntity;
            String coord = entity.getShapeCoords();
            StringTokenizer st = new StringTokenizer(coord, ",");
            int minx = Integer.MAX_VALUE;
            int maxx = Integer.MIN_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxy = Integer.MIN_VALUE;
            boolean coordX = true;
            while (st.hasMoreTokens()) {
                int v = Integer.valueOf(st.nextToken());
                if (coordX) {
                    if (v > maxx) {
                        maxx = v;
                    }
                    if (v < minx) {
                        minx = v;
                    }
                } else {
                    if (v > maxy) {
                        maxy = v;
                    }
                    if (v < miny) {
                        miny = v;
                    }
                }
                boolean bl = coordX = !coordX;
            }
            rect = new Rectangle2D.Double(minx - m_marge, miny - m_marge, maxx - minx + m_marge * 2, maxy - miny + m_marge * 2);
        } else {
            rect = this.getRectConfiance(event);
        }
        return rect;
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent event) {
    }

    private void demarrerAttente(Qualifiable quali) {
        if (quali != null) {
            if (this.m_qualifiableSousSouris == null || !this.m_qualifiableSousSouris.equals(quali)) {
                this.timer.restart();
                this.m_qualifiableSousSouris = quali;
            }
        } else if (this.m_qualifiableSousSouris != null) {
            this.m_qualifiableSousSouris = null;
            this.mettreAJourHabillage(null);
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.timer.stop();
        this.mettreAJourHabillage(this.m_qualifiableSousSouris);
    }

    private void mettreAJourHabillage(Qualifiable don) {
        if ((don != null || this.m_habillage != null) && don != this.m_habillage) {
            this.m_habillage = don;
            this.m_gest.setDescription(don);
            this.m_gest.sauverAnnotations();
            this.m_gest.updateGraphe();
        }
    }
}

