% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/highlight.R
\name{dyHighlight}
\alias{dyHighlight}
\title{dygraph series mouse-over highlighting}
\usage{
dyHighlight(dygraph, highlightCircleSize = 3,
  highlightSeriesBackgroundAlpha = 0.5, highlightSeriesOpts = list(),
  hideOnMouseOut = TRUE)
}
\arguments{
\item{dygraph}{Dygraph to configure highlighting behavior for.}

\item{highlightCircleSize}{The size in pixels of the dot drawn over
highlighted points.}

\item{highlightSeriesBackgroundAlpha}{Fade the background while highlighting
series. 1=fully visible background (disable fading), 0=hidden background
(show highlighted series only).}

\item{highlightSeriesOpts}{When set, the options from this list are applied
to the series closest to the mouse pointer for interactive highlighting.
Example: list(strokeWidth = 3). See the documentation on
\code{\link{dySeries}} for additional details on options that can be set.}

\item{hideOnMouseOut}{Whether to hide the highlighting effects when the mouse
  leaves the chart area. Note that this also affects the hiding of the
  \code{\link{dyLegend}} on mouse out.}
}
\value{
A dygraph with customized highlighting options
}
\description{
Configure options for data series mouse-over highlighting. Note that
highlighting is always enabled for dygraphs so this function is used to
customize rather than enable highlighting.
}
\note{
See the
\href{http://rstudio.github.io/dygraphs/gallery-series-highlighting.html}{online
documentation} for additional details and examples.
}
\examples{
library(dygraphs)
lungDeaths <- cbind(ldeaths, mdeaths, fdeaths)
dygraph(lungDeaths, main = "Deaths from Lung Disease (UK)") \%>\%
  dyHighlight(highlightCircleSize = 5,
              highlightSeriesBackgroundAlpha = 0.2,
              hideOnMouseOut = FALSE)
}

