% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_files_by_source.R
\name{add_file_by_source}
\alias{add_file_by_source}
\title{Add a single file to a dataset.}
\usage{
add_file_by_source(dataset, name, url)
}
\arguments{
\item{dataset}{Dataset URL or path.}

\item{name}{File name including the file extension. If a file by that name already
exists in the dataset, the file will be updated/overwritten.}

\item{url}{Source URL of file.}
}
\value{
Object of type \code{\link{success_message}}.
}
\description{
Add a single file to a dataset.
}
\examples{
\dontrun{
  dwapi::add_file_by_source(dataset = 'user/dataset',
    name = 'file.csv', url = 'https://data.world/some_file.csv')
}
}
