% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sum_i}
\alias{sum_i}
\title{Sum of Integer Values}
\usage{
sum_i(x)
}
\arguments{
\item{x}{Integer vector or matrix.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function runs faster than \code{\link[base]{sum}} for 
large integer vectors/matrices.
}
\examples{
# For very large integer objects, sum_i is faster than sum
x <- rpois(100000, lambda = 5)
sum(x) == sum_i(x)
benchmark(sum(x), sum_i(x), replications = 1000)

# For smaller integer objects, sum_i is slower than sum 
x <- rpois(1000, lambda = 5)
sum(x) == sum_i(x)
benchmark(sum(x), sum_i(x), replications = 1000)

}
