% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi4.R
\name{bmi4}
\alias{bmi4}
\title{Convert Continuous BMI Values into 4-Level Factor}
\usage{
bmi4(x, labels = TRUE)
}
\arguments{
\item{x}{Numeric vector of BMI values.}

\item{labels}{If \code{TRUE}, factor levels are labeled \code{"Underweight"}, 
\code{"Normal weight"}, \code{"Overweight"}, and \code{"Obese"}; if 
\code{FALSE}, factor levels are \code{[-Inf, 18.5)}, \code{[18.5, 25)}, 
\code{[25, 30)}, and \code{[30, Inf)}.}
}
\value{
Factor variable with 4 levels.
}
\description{
Converts a continuous BMI variable into a 4-level factor variable: 
Underweight if \code{[-Inf, 18.5)}, Normal weight if \code{[18.5, 25)}, 
Overweight if \code{[25, 30)}, and Obese if \code{[30, Inf)}.
}
