% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPairing.R
\name{setPairing}
\alias{setPairing}
\title{Set identifications manually}
\usage{
setPairing(
  dvi,
  match = NULL,
  victim = NULL,
  missing = NULL,
  Conclusion = "Provided",
  Comment = "",
  verbose = TRUE
)
}
\arguments{
\item{dvi}{A DVI dataset.}

\item{match}{A named vector of the format c(vic1 = miss2, vic2 = miss2, ...).}

\item{victim}{A vector of victim sample names. If NULL, defaulting to
\code{names(match)}.}

\item{missing}{A vector of missing person names, of the same length as
\code{victim}. If NULL, defaulting to \code{as.character(match)}.}

\item{Conclusion}{A character passed on to the \code{Conclusion} column of the
output summary.}

\item{Comment}{A character passed on to the \code{Comment} column of the output
summary.}

\item{verbose}{A logical, by default TRUE.}
}
\value{
A list with the following entries:
\itemize{
\item \code{dviReduced}: The new \code{dviData} object, as described in Details
\item \code{summary}: A data frame summarising the identifications
}
}
\description{
Manually set one or several identifications in a DVI dataset. Typically,
these are obtained by external means, e.g., fingerprints, dental records etc.
}
\details{
The command \code{setPairing(dvi, c("V" = "M"))} does the following:
\itemize{
\item Transfer the data of victim "V" to the individual "M" in the appropriate
reference family
\item Remove "M" from the list of missing persons
\item Remove "V" from the list of victim samples
\item Update the list of pairings
}
}
\examples{
x = setPairing(example2, match = c("V3" = "M2"))
x$dviReduced
x$summary

# Alternative syntax, using `victim` and `missing`
y = setPairing(planecrash, victim = c("V4", "V5"), missing = c("M4", "M5"),
           Conclusion = "External evidence", Comment = "Dental")
y$dviReduced
y$summary

}
