% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sibPairs}
\alias{sibPairs}
\title{Data. Simulated sib pairs}
\format{
A list of 3 elements:
\itemize{
\item \code{pm}: A list of 20 singletons (victims).
\item \code{am}: A list of 10 pedigrees.
\item \code{missing}: A vector containing the names of the 20 missing persons.
}
}
\usage{
sibPairs
}
\description{
The purpose of this data is to challenge brute force methods. We use the
the database NorwegianFrequencies.
There are 10 males (V1, V3, ..., V19) and 10 female victims (V2, V4, ..., V20).
There are 10 reference families. In each family there is a genotyped grandmother
and a missing grandson and a missing granddaughter. The data is simulated according to
Vi = Mi, i = 1, ..., 20.
}
\examples{

\donttest{
# Remove comments to run example
# Number of possible assignments
ncomb(10, 10, 10, 10) 

pm = sibPairs$pm
am = sibPairs$am
missing = sibPairs$missing
sequentialDVI(pm, am, missing, updateLR = TRUE)
# jointDVI(pm, am, missing, threshold = 100)

# Reduce to 15 markers. `sequentialDVI` still gives correct solutions,
# but `jointDVI` struggles. Recommend sequential approach or possible to modify the joint?
set1 = c("CSF1PO", "D2S1338", "D3S1358", "D5S818", "D7S820", "D8S1179", "D13S317", "D16S539",
       "D18S51", "D19S433", "D21S11", "FGA", "TH01", "TPOX", "VWA")

# jointDVI(pm, am, missing, markers = set1, threshold = 10)
}
}
\keyword{datasets}
