% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.twdtw_knn1}
\alias{predict.twdtw_knn1}
\title{Predict using the twdtw_knn1 model}
\usage{
\method{predict}{twdtw_knn1}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{twdtw_knn1} model object generated by the \code{twdtw_knn1} function.}

\item{newdata}{A data frame or similar object containing the new observations
(time series data) to be predicted.}

\item{...}{Additional arguments passed to the \link[twdtw]{twdtw} function.
If provided, they will overwrite twdtw arguments previously passed to \link[dtwSat]{twdtw_knn1}.}
}
\value{
A vector of predicted classes for the \code{newdata}.
}
\description{
This function predicts the classes of new data using the Time Warped Dynamic Time Warping (TWDTW)
method with a 1-nearest neighbor approach. The prediction is based on the minimum TWDTW distance
to the known patterns stored in the \code{twdtw_knn1} model.
}
\examples{
\dontrun{

# Read training samples
samples_path <- 
  system.file("mato_grosso_brazil/samples.gpkg", package = "dtwSat")

samples <- st_read(samples_path, quiet = TRUE)

# Get satellite image time sereis files
tif_path <- system.file("mato_grosso_brazil", package = "dtwSat")
tif_files <- dir(tif_path, pattern = "\\\\.tif$", full.names = TRUE)

# Get acquisition dates
acquisition_date <- regmatches(tif_files, regexpr("[0-9]{8}", tif_files))
acquisition_date <- as.Date(acquisition_date, format = "\%Y\%m\%d")

# Create a 3D datacube
dc <- read_stars(tif_files,
                 proxy = FALSE,
                 along = list(time = acquisition_date),
                 RasterIO = list(bands = 1:6))
dc <- st_set_dimensions(dc, 3, c("EVI", "NDVI", "RED", "BLUE", "NIR", "MIR"))
dc <- split(dc, c("band"))

# Create a knn1-twdtw model
m <- twdtw_knn1(x = dc,
                y = samples,
                cycle_length = 'year',
                time_scale = 'day',
                time_weight = c(steepness = 0.1, midpoint = 50),
                formula = band ~ s(time))

print(m)

# Visualize model patterns
plot(m)

# Classify satellite images
system.time(lu <- predict(dc, model = m))

# Visualise land use classification
ggplot() +
  geom_stars(data = lu) +
  theme_minimal()

}
}
\seealso{
twdtw_knn1
}
