% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotprod.R
\name{dotprod}
\alias{dotprod}
\title{Generalized inner product of two matrices}
\usage{
dotprod(x, y, g, f)
}
\arguments{
\item{x}{A matrix of M rows by K columns.}

\item{y}{A matrix of K rows by N columns.}

\item{g}{Any operator: +, -, *, /, &, |, ==, <=, paste etc.}

\item{f}{Any operator: +, -, *, /, &, |, ==, <=, paste etc.}
}
\value{
The result of the generalized inner product is returned.
}
\description{
The generalized inner product of two matrices combines two operators in the same manner as the classical inner product defined for the multiplication of two matrices. The number of rows of the second matrix must be equal the number of columns of the first matrix.
}
\examples{
print("Standard matrix product")
x <- y <- matrix(c(1:6), nrow = 2, byrow = TRUE)
dotprod(x, t(y), g = "+", f = "*")  ## same as x \%*\% t(y)
print("Find some data x2 in the rows of a larger matrix y2")
x2 <- matrix(c(1,0,0,1,1,1), nrow = 2, byrow = TRUE)
y2 <- matrix(c(1,0,0,0,1,0,1,1,0,0,1,1,1,1,1), 
nrow = 5, byrow = TRUE)
(1:nrow(y2)) * dotprod(x2, t(y2), g = "&", f = "==")

print("Find some names in a long list")
team_names <- matrix(c("Patrick", "Dole", "Amanda",
 "Dole", "Robert", "Calvin", "Alvina", "Klein",
  "Robert", "Gariepy", "Nellie", "Arcand"),
   ncol = 2, byrow = TRUE)
colnames(team_names) <- c("First_name", "Last_name")
print("Where in the list are the person with first name Robert and where are the Doles?")
BobandDoles <- matrix(c("Robert", "", "", "Dole"),
 ncol = 2, byrow = TRUE)
dotprod(team_names, t(BobandDoles),g="|",f="==") * (1:nrow(team_names))
}
\author{
Claude Boivin
}
