% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_group_extract.R
\name{str_group_extract}
\alias{str_group_extract}
\title{Extract Regular Expression Groups}
\usage{
str_group_extract(string, pattern, group = NULL, nas = TRUE)
}
\arguments{
\item{string}{string to extract from}

\item{pattern}{pattern with groups to match}

\item{group}{groups to extract}

\item{nas}{return NA values (TRUE) or filter them out (FALSE)}
}
\value{
string vector or string matrix
}
\description{
Extract Regular Expression Groups
}
\examples{

strings <- paste(LETTERS, seq_along(LETTERS), sep = "_")
str_group_extract(strings, "([\\\\w])_(\\\\d+)")
str_group_extract(strings, "([\\\\w])_(\\\\d+)", 1)
str_group_extract(strings, "([\\\\w])_(\\\\d+)", 2)

}
