% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfalling_object.R
\name{rfalling_object}
\alias{rfalling_object}
\title{Simulate falling object data}
\usage{
rfalling_object(n = 14, d_0 = 55.86, v_0 = 0, g = -9.8, scale = 1,
  time = seq(0, 3.25, length.out = n), error_distribution = c("rnorm",
  "rt"), df = 3)
}
\arguments{
\item{n}{Sample size}

\item{d_0}{Height from which object will fall in meters.}

\item{v_0}{Initial velocity with which object will fall in meters per second.}

\item{g}{Gravitational constnant, 9.8 meters per second per seonnd}

\item{scale}{The measurement errors will be multiplied by this constant.}

\item{time}{Numeric vector of times, in seconds, at which measurements were taken.}

\item{error_distribution}{Character. Either \code{rnorm} for normal or \code{rt} for t-distribution.}

\item{df}{If using t-distribution, the degrees of freedom.}
}
\value{
A \code{data.frame} with the time, the distance travelled, and the observed distance.
}
\description{
The function simulates a falling object measurements. Default parameters are for dropping an weight from the tower of Pisa
}
\examples{

dat <- rfalling_object()
with(dat, plot(time, observed_distance))
with(dat, lines(time, distance, col = "blue"))

}
