% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/Simulation.R,
%   R/Survey.LT.R, R/Survey.PT.R
\name{run.survey}
\alias{run.survey}
\alias{run.survey,Simulation-method}
\alias{run.survey,Survey.LT-method}
\alias{run.survey,Survey.PT-method}
\title{S4 generic method to simulate a survey}
\usage{
run.survey(object, ...)

\S4method{run.survey}{Simulation}(object, filename = character(0))

\S4method{run.survey}{Survey.LT}(object, region = NULL)

\S4method{run.survey}{Survey.PT}(object, region = NULL)
}
\arguments{
\item{object}{an object of class Simulation}

\item{...}{allows extra arguments}

\item{filename}{optional argument specifying a path to a shapefile if 
the transects are to be loaded from file.}

\item{region}{an object of class Region.}
}
\value{
An object which inherits from a \code{\link{Survey-class}} object.
This will be a \code{\link{Survey.LT-class}} object in the case of a
simulation with a line transect design and a \code{\link{Survey.PT-class}}
if the simulation has a point transect design.
}
\description{
Simulates the process by which individuals or clusters are detected. If
a simulation is passed in then it will generate a population, set of
transects and simulate the detection process. If a survey is passed in
it will simply simulate the detection process. See
\code{\link{make.simulation}} for example usage.
}
\seealso{
\code{\link{make.simulation}}
}
