% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{efficiency}
\alias{efficiency}
\title{efficiency}
\usage{
efficiency(object, alpha = 0.05, type = "jondrow")
}
\arguments{
\item{object}{fitted mgcv object with family \code{comper()} or \code{comper_mv()}.}

\item{alpha}{for the \eqn{(1-\alpha) \cdot 100\%} confidence interval. Must be in (0,1).}

\item{type}{default is "jondrow" for \eqn{E[u|\epsilon]}, alternatively "battese" for \eqn{E[\exp(-u)|\epsilon]}.}
}
\value{
Returns a matrix of the expected (in)efficiency estimates as well the lower and upper bound of the \eqn{(1-\alpha)\cdot 100\%} confidence interval.
}
\description{
Calculates the expected technical (in)efficiency index.
}
\examples{
#Set seed, sample size and type of function
set.seed(1337)
N=500 #Sample size
s=-1 #Set to production function

#Generate covariates
x1<-runif(N,-1,1); x2<-runif(N,-1,1); x3<-runif(N,-1,1)
x4<-runif(N,-1,1); x5<-runif(N,-1,1)

#Set parameters of the distribution
mu=2+0.75*x1+0.4*x2+0.6*x2^2+6*log(x3+2)^(1/4) #production function parameter
sigma_v=exp(-1.5+0.75*x4) #noise parameter
sigma_u=exp(-1+sin(2*pi*x5)) #inefficiency parameter

y<-rcomper(n=N, mu=mu, sigma_v=sigma_v, sigma_u=sigma_u, s=s, distr="normhnorm")
dat<-data.frame(y, x1, x2, x3, x4, x5)

#Write formulae for parameters
mu_formula<-y~x1+x2+I(x2^2)+s(x3, bs="ps")
sigma_v_formula<-~1+x4
sigma_u_formula<-~1+s(x5, bs="ps")

#Fit model
model<-mgcv::gam(formula=list(mu_formula, sigma_v_formula, sigma_u_formula),
                 data=dat, family=comper(s=s, distr="normhnorm"), optimizer = c("efs"))
                                   
#Estimate efficiency
efficiency(model, type="jondrow")
efficiency(model, type="battese")

}
\references{
\itemize{
\item \insertRef{schmidt2022mvdsfm}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
\item \insertRef{jondrow1982estimation}{dsfa}
\item \insertRef{battese1988prediction}{dsfa}
}
}
