% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comperr_mv.R
\name{dcomperr_mv}
\alias{dcomperr_mv}
\alias{dcomperr_mv,}
\alias{pcomperr_mv,}
\alias{rcomperr_mv}
\alias{pcomperr_mv}
\title{Composed error multivariate distribution}
\usage{
dcomperr_mv(
  x1 = 0,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  dist1 = "normhnorm",
  x2 = 0,
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  dist2 = "normhnorm",
  Tau = 0,
  family = 1,
  deriv = 0,
  xg = NULL,
  log.p = FALSE
)

pcomperr_mv(
  q1 = 0,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  dist1 = "normhnorm",
  q2 = 0,
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  dist2 = "normhnorm",
  Tau = 0,
  family = 1,
  deriv = 0,
  xg = NULL,
  log.p = FALSE
)

rcomperr_mv(
  n,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  dist1 = "normhnorm",
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  dist2 = "normhnorm",
  Tau = 0,
  family = 1
)
}
\arguments{
\item{x1}{vector of quantiles for margin 1.}

\item{mu1}{vector of \eqn{\mu} for margin 1}

\item{sigma_v1}{vector of \eqn{\sigma_V} for margin 1. Must be positive.}

\item{par_u1}{vector of \eqn{\sigma_U} for margin 1. Must be positive.}

\item{s1}{\eqn{s=-1} for production and \eqn{s=1} for cost function for margin 1.}

\item{dist1}{specifying the distribution of margin 1.}

\item{x2}{vector of quantiles for margin 2.}

\item{mu2}{vector of \eqn{\mu} for margin 2}

\item{sigma_v2}{vector of \eqn{\sigma_V} for margin 2. Must be positive.}

\item{par_u2}{vector of \eqn{\sigma_U} for margin 2. Must be positive.}

\item{s2}{\eqn{s=-1} for production and \eqn{s=1} for cost function for margin 2.}

\item{dist2}{specifying the distribution of margin 1.}

\item{Tau}{matrix of Kendall's tau.}

\item{family}{integer, defines the bivariate copula family:\cr
\code{1} = Gaussian copula \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are 1,2,3,4.}

\item{xg}{optional, index arrays for upper triangular matrices, generated by \code{trind.generator(K)} and supplied to \code{chainrule}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q1}{vector of quantiles for margin 1.}

\item{q2}{vector of quantiles for margin 2.}

\item{n}{number of observations.}
}
\value{
\code{dcomperr_mv} gives the density and \code{rcomperr_mv} generates random numbers, with given parameters. If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4} of the output of the density.
}
\description{
Probablitiy density function, distribution and random number generation for the composed error multivariate distribution.
}
\details{
A bivariate random vector \eqn{(Y_1,Y_2)} follows a composed error multivariate distribution \eqn{f_{Y_1,Y_2}(y_1,y_2)}, which can be rewritten using Sklars' theorem via a copula
\deqn{f_{Y_1,Y_2}(y_1,y_2)=c(F_{Y_1}(y_1),F_{Y_2}(y_2),\tau) \cdot f_{Y_1}(y_1) f_{Y_2}(y_2) \qquad,}
where \eqn{c(\cdot)} is a copula function and \eqn{F_{Y_m}(y_m)},\eqn{f_{Y_m}(y_m)} are the marginal cdf and pdf respectively. \eqn{Tau} is Kendall's Tau.
}
\section{Functions}{
\itemize{
\item \code{pcomperr_mv()}: distribution function for the composed error multivariate distribution.

\item \code{rcomperr_mv()}: random number generation for the composed error multivariate distribution.

}}
\examples{
pdf<-dcomperr_mv(x1=5, mu1=2, sigma_v1=3, par_u1=4, s1=-1, dist1="normhnorm",
                 x2=-5, mu2=2, sigma_v2=3, par_u2=4, s2=-1, dist2="normhnorm",
            Tau=0.5, family=1, deriv = 2, xg=NULL, log.p=FALSE)
cdf<-pcomperr_mv(q1=0, mu1=0, sigma_v1=1, par_u1=1, s1=-1, dist1="normhnorm",
            q2=0, mu2=0, sigma_v2=1, par_u2=1, s2=-1, dist2="normhnorm",
            Tau=0.5, family=1, deriv = 0, xg=NULL, log.p=FALSE)
r<-rcomperr_mv(n=100, mu1=0, sigma_v1=1, par_u1=1, s1=-1, dist1="normhnorm",
          mu2=0, sigma_v2=1, par_u2=1, s2=-1, dist2="normhnorm",
          Tau=matrix(0.5,nrow=100), family=1)

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
}
}
