% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{normalize}
\alias{normalize}
\title{Normalize distribution}
\usage{
normalize(d, qp)
}
\arguments{
\item{d}{A vector with \code{length(qp)} elements representing
the unscaled density at each quadrature point.}

\item{qp}{Vector of equally spaced quadrature points.}
}
\value{
A vector of \code{length(d)} elements with
the prior density estimate at each quadature point.
}
\description{
Normalizes the distribution so that the total mass equals 1.
}
\note{
: Internal function
}
\examples{
dscore:::normalize(c(5, 10, 5), qp = c(0, 1, 2))

sum(dscore:::normalize(rnorm(5), qp = 1:5))
}
